<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ভিআইপি পণ্য - বিনিয়োগ প্ল্যাটফর্ম</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #4CAF50;
            --primary-dark: #45a049;
            --dark-bg: #000;
            --text-light: #f8f9fa;
            --text-dark: #333;
            --text-gray: #666;
            --card-bg: #1a1a1a;
            --border-color: rgba(255,255,255,0.1);
            --success-color: #28a745;
            --error-color: #dc3545;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--dark-bg);
            color: var(--text-light);
            line-height: 1.6;
            padding-bottom: 80px;
        }
        
        /* Header Styles */
        .header {
            background: linear-gradient(135deg, #000102 0%, #1e3a5f 100%);
            color: white;
            padding: 20px 0;
            position: relative;
            overflow: hidden;
        }
        
        .header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(45deg, rgba(255,255,255,0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            position: relative;
            z-index: 1;
        }
        
        .balance-section {
            display: flex;
            gap: 40px;
        }
        
        .balance-item {
            text-align: left;
        }
        
        .balance-label {
            font-size: 14px;
            opacity: 0.9;
            margin-bottom: 5px;
            color: rgba(255,255,255,0.8);
        }
        
        .balance-value {
            font-size: 24px;
            font-weight: 700;
            color: white;
        }
        
        /* Main Content */
        .main-content {
            background: var(--dark-bg);
            border-radius: 20px 20px 0 0;
            margin-top: -10px;
            position: relative;
            z-index: 2;
            min-height: calc(100vh - 200px);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 30px 20px;
        }
        
        .page-header {
            text-align: center;
            margin-bottom: 40px;
        }
        
        .page-title {
            font-size: 32px;
            font-weight: 800;
            color: white;
            margin-bottom: 10px;
        }
        
        .page-subtitle {
            font-size: 16px;
            color: rgba(255,255,255,0.7);
            font-weight: 400;
        }
        
        /* Tab Navigation */
        .tab-navigation {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-bottom: 40px;
            background: rgba(255,255,255,0.1);
            padding: 10px;
            border-radius: 15px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.2);
            flex-wrap: wrap;
        }
        
        .tab-btn {
            background: transparent;
            border: none;
            padding: 12px 25px;
            border-radius: 10px;
            cursor: pointer;
            display: flex;
            align-items: center;
            gap: 10px;
            font-size: 16px;
            font-weight: 600;
            color: rgba(255,255,255,0.7);
            transition: all 0.3s ease;
            position: relative;
        }
        
        .tab-btn:hover {
            background: rgba(255,255,255,0.1);
            color: white;
        }
        
        .tab-btn.active {
            background: var(--primary-color);
            color: white;
            box-shadow: 0 4px 15px rgba(76, 175, 80, 0.3);
        }
        
        .tab-btn i {
            font-size: 18px;
        }
        
        /* Tab Content */
        .tab-content {
            display: none;
            animation: fadeIn 0.5s ease;
        }
        
        .tab-content.active {
            display: block;
        }
        
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Products Grid */
        .products-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 25px;
        }
        
        /* Product Cards */
        .product-card {
            background: var(--card-bg);
            color: white;
            border-radius: 20px;
            padding: 30px;
            position: relative;
            overflow: hidden;
            transition: all 0.3s ease;
            box-shadow: 0 8px 30px rgba(0,0,0,0.2);
            border: 1px solid rgba(255,255,255,0.05);
        }
        
        .product-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-color) 0%, var(--primary-dark) 100%);
        }
        
        .product-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.3);
        }
        
        .product-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .product-category {
            background: rgba(255,255,255,0.1);
            padding: 6px 12px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            color: white;
        }
        
        .product-status {
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: var(--primary-color);
            position: relative;
        }
        
        .product-status.active::after {
            content: '';
            position: absolute;
            width: 12px;
            height: 12px;
            border-radius: 50%;
            background: var(--primary-color);
            animation: pulse 2s infinite;
        }
        
        @keyframes pulse {
            0% { transform: scale(1); opacity: 1; }
            100% { transform: scale(2); opacity: 0; }
        }
        
        .product-name {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 25px;
            color: white;
        }
        
        .product-details {
            margin-bottom: 30px;
        }
        
        .detail-item {
            display: flex;
            align-items: center;
            gap: 15px;
            margin-bottom: 20px;
            padding: 15px 0;
            border-bottom: 1px solid var(--border-color);
        }
        
        .detail-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
        }
        
        .detail-item i {
            font-size: 18px;
            color: var(--primary-color);
            width: 20px;
            text-align: center;
        }
        
        .detail-content {
            flex: 1;
        }
        
        .detail-label {
            display: block;
            font-size: 14px;
            color: rgba(255,255,255,0.7);
            margin-bottom: 5px;
        }
        
        .detail-value {
            font-size: 18px;
            font-weight: 700;
            color: white;
        }
        
        .invest-btn {
            width: 100%;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            padding: 15px 25px;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 10px;
            transition: all 0.3s ease;
            position: relative;
            overflow: hidden;
        }
        
        .invest-btn::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255,255,255,0.2), transparent);
            transition: left 0.5s;
        }
        
        .invest-btn:hover::before {
            left: 100%;
        }
        
        .invest-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(76, 175, 80, 0.3);
        }
        
        .invest-btn:active {
            transform: translateY(0);
        }
        
        .invested-badge {
            background: rgba(76, 175, 80, 0.2);
            color: var(--primary-color);
            padding: 12px;
            border-radius: 8px;
            text-align: center;
            font-weight: 600;
            margin-top: 20px;
            border: 1px solid rgba(76, 175, 80, 0.3);
        }
        
        .invested-badge i {
            margin-right: 8px;
        }
        
        /* Active Investments Section */
        .active-investments {
            margin-top: 50px;
            padding-top: 30px;
            border-top: 1px solid var(--border-color);
        }
        
        .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 25px;
            color: white;
            text-align: center;
        }
        
        .investments-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 20px;
        }
        
        .investment-card {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 20px;
            border: 1px solid rgba(255,255,255,0.05);
            box-shadow: 0 5px 15px rgba(0,0,0,0.1);
        }
        
        .investment-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
            padding-bottom: 15px;
            border-bottom: 1px solid var(--border-color);
        }
        
        .investment-header h3 {
            font-size: 18px;
            font-weight: 600;
            color: white;
        }
        
        .days-remaining {
            background: rgba(76, 175, 80, 0.2);
            color: var(--primary-color);
            padding: 5px 10px;
            border-radius: 20px;
            font-size: 12px;
            font-weight: 600;
        }
        
        .detail-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            font-size: 14px;
        }
        
        .detail-row span {
            color: rgba(255,255,255,0.7);
        }
        
        .detail-row strong {
            color: white;
            font-weight: 600;
        }
        
        .no-investments {
            text-align: center;
            padding: 30px;
            background: rgba(255,255,255,0.05);
            border-radius: 10px;
            color: rgba(255,255,255,0.7);
        }
        
        .no-investments i {
            font-size: 40px;
            margin-bottom: 15px;
            color: rgba(255,255,255,0.3);
        }
        
        /* Footer Menu */
        .footer-menu {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1a1a1a;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            z-index: 1000;
        }
        
        .footer-content {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 15px 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        
        .footer-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #cccccc;
            transition: all 0.3s ease;
            padding: 8px;
            border-radius: 10px;
        }
        
        .footer-item:hover,
        .footer-item.active {
            color: #ffffff;
            background: rgba(255, 255, 255, 0.1);
        }
        
        .footer-icon {
            font-size: 20px;
            margin-bottom: 5px;
        }
        
        .footer-text {
            font-size: 12px;
            font-weight: 500;
        }
        
        /* Modal Styles */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 2000;
            opacity: 0;
            visibility: hidden;
            transition: all 0.3s ease;
        }
        
        .modal-overlay.active {
            opacity: 1;
            visibility: visible;
        }
        
        .modal-content {
            background: #1e1e1e;
            border-radius: 15px;
            width: 90%;
            max-width: 400px;
            padding: 30px;
            text-align: center;
            transform: translateY(20px);
            transition: all 0.3s ease;
            box-shadow: 0 10px 30px rgba(0,0,0,0.3);
        }
        
        .modal-overlay.active .modal-content {
            transform: translateY(0);
        }
        
        .modal-icon {
            font-size: 50px;
            margin-bottom: 20px;
        }
        
        .modal-icon.success {
            color: var(--success-color);
        }
        
        .modal-icon.error {
            color: var(--error-color);
        }
        
        .modal-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 10px;
            color: white;
        }
        
        .modal-message {
            font-size: 16px;
            color: rgba(255,255,255,0.8);
            margin-bottom: 25px;
            line-height: 1.5;
        }
        
        .modal-btn {
            background: var(--primary-color);
            color: white;
            border: none;
            padding: 12px 25px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
        }
        
        .modal-btn:hover {
            background: var(--primary-dark);
            transform: translateY(-2px);
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .header-content {
                flex-direction: column;
                gap: 20px;
                text-align: center;
            }
            
            .balance-section {
                gap: 30px;
                width: 100%;
                justify-content: center;
            }
            
            .page-title {
                font-size: 24px;
            }
            
            .tab-navigation {
                gap: 10px;
                padding: 8px;
            }
            
            .tab-btn {
                padding: 10px 15px;
                font-size: 14px;
            }
            
            .products-grid {
                grid-template-columns: 1fr;
                gap: 20px;
            }
            
            .product-card {
                padding: 25px;
            }
            
            .container {
                padding: 20px 15px;
            }
        }
        
        @media (max-width: 480px) {
            .balance-section {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .balance-value {
                font-size: 20px;
            }
            
            .product-name {
                font-size: 18px;
            }
            
            .detail-value {
                font-size: 16px;
            }
            
            .tab-btn span {
                display: none;
            }
            
            .tab-btn i {
                margin-right: 0;
            }
        }
        
        /* Animations */
        .fade-in {
            animation: fadeIn 0.5s ease forwards;
        }
        
        .slide-up {
            animation: slideUp 0.5s ease forwards;
        }
        
        @keyframes slideUp {
            from { opacity: 0; transform: translateY(30px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        /* Loading Spinner */
        .spinner {
            width: 24px;
            height: 24px;
            border: 3px solid rgba(255,255,255,0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        @media (max-width: 480px) {
        /* এই অংশটি পরিবর্তন করুন */
        .tab-btn span {
            display: inline !important; /* টেক্সট দেখাবে */
            font-size: 12px; /* ছোট ফন্ট সাইজ */
        }
        
        .tab-btn i {
            margin-right: 5px; /* আইকন এবং টেক্সটের মধ্যে স্পেস */
        }
        
        /* বাকি স্টাইল */
        .balance-section {
            flex-direction: column;
            gap: 15px;
            text-align: center;
        }
        
        .balance-value {
            font-size: 20px;
        }
        
        .product-name {
            font-size: 18px;
        }
        
        .detail-value {
            font-size: 16px;
        }
    }

.inline-invested {
    background: rgba(220, 53, 69, 0.1);
    color: #dc3545;
    padding: 12px;
    border-radius: 8px;
    text-align: center;
    font-weight: 600;
    border: 1px solid rgba(220, 53, 69, 0.3);
    width: 100%;
}

.inline-invested i {
    font-size: 18px;
    margin-right: 8px;
}

.inline-invested small {
    display: block;
    font-size: 12px;
    color: rgba(220, 53, 69, 0.8);
    margin-top: 5px;
    font-weight: normal;
}
    /* Inline VIP Card Design */
.inline-vip-card {
    background: #1e1e1e;
    border-radius: 10px;
    border: 1px solid rgba(255,255,255,0.1);
    padding: 15px;
    margin-bottom: 15px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.inline-card-header {
    display: flex;
    align-items: center;
    gap: 10px;
    margin-bottom: 15px;
    flex-wrap: wrap;
}

.inline-badge {
    background: #4CAF50;
    color: white;
    padding: 3px 10px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 600;
}

.inline-title {
    font-size: 16px;
    font-weight: 600;
    color: white;
    margin: 0;
    flex: 1;
}

.inline-featured {
    background: rgba(255,193,7,0.2);
    color: #ffc107;
    padding: 3px 8px;
    border-radius: 15px;
    font-size: 11px;
    font-weight: 600;
}

.inline-status {
    width: 8px;
    height: 8px;
    border-radius: 50%;
    background: #6c757d;
}

.inline-status.active {
    background: #4CAF50;
    box-shadow: 0 0 5px rgba(76, 175, 80, 0.5);
}

.inline-details {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px;
    margin-bottom: 15px;
}

.inline-row {
    display: flex;
    justify-content: space-between;
}

.inline-label {
    font-size: 13px;
    color: rgba(255,255,255,0.7);
}

.inline-value {
    font-size: 13px;
    font-weight: 600;
    color: white;
}

.inline-features {
    background: rgba(255,255,255,0.05);
    border-radius: 8px;
    padding: 12px;
    margin-bottom: 15px;
}

.inline-features-title {
    font-size: 14px;
    font-weight: 600;
    color: #4CAF50;
    margin-bottom: 8px;
    text-align: center;
}

.inline-features-text {
    font-size: 13px;
    color: rgba(255,255,255,0.8);
    line-height: 1.5;
    text-align: center;
}

.inline-action {
    display: flex;
    justify-content: center;
}

.inline-btn {
    padding: 10px 15px;
    border-radius: 8px;
    border: none;
    font-size: 14px;
    font-weight: 600;
    cursor: pointer;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: all 0.3s ease;
}

.inline-btn.invest {
    background: #4CAF50;
    color: white;
}

.inline-btn.invest:hover {
    background: #45a049;
    transform: translateY(-2px);
}

.inline-btn.disabled {
    background: #6c757d;
    color: white;
    cursor: not-allowed;
}

.inline-invested {
    background: rgba(76, 175, 80, 0.1);
    color: #4CAF50;
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    display: flex;
    align-items: center;
    gap: 8px;
}

/* Responsive */
@media (max-width: 480px) {
    .inline-details {
        grid-template-columns: 1fr;
    }
    
    .inline-card-header {
        gap: 8px;
    }
    
    .inline-title {
        font-size: 15px;
    }
}

  .tab-btn i {
        margin-right: 8px;
        color: #ffc107; /* Gold color for VIP icons */
    }
    
    .tab-btn.active i {
        color: #ffffff; /* White color when active */
    }
    
    /* Specific icon colors if needed */
    .fa-star {
        color: #ffc107; /* Gold star */
    }
    
    .fa-crown {
        color: #ffc107; /* Gold crown */
    }
    
    .fa-gem {
        color: #4e73df; /* Blue gem */
    }
    
    .fa-award {
        color: #1cc88a; /* Green award */
    }
      .tab-btn:hover i {
        transform: scale(1.1);
        transition: transform 0.3s ease;
    }
    
    /* ইতিমধ্যে ক্রয়কৃত বাটনের স্টাইল */
.inline-btn.disabled.already-purchased {
    background: rgba(220, 53, 69, 0.2);
    color: #dc3545;
    border: 1px solid rgba(220, 53, 69, 0.3);
}

.inline-btn.disabled.already-purchased:hover {
    background: rgba(220, 53, 69, 0.3);
}

.inline-btn.disabled {
    background: rgba(108, 117, 125, 0.2);
    color: #6c757d;
    border: 1px solid rgba(108, 117, 125, 0.3);
    cursor: not-allowed;
}

/* বিনিয়োগকৃত ব্যাজ স্টাইল */
.inline-invested {
    background: rgba(40, 167, 69, 0.1);
    color: #28a745;
    padding: 10px 15px;
    border-radius: 8px;
    font-size: 13px;
    font-weight: 500;
    display: flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    border: 1px solid rgba(40, 167, 69, 0.2);
}
    </style>
</head>
<body>
  <div class="container">
    <header class="header">
        <div class="header-content">
            <div class="balance-section">
                <div class="balance-item">
                    <div class="balance-label">মোট বিনিয়োগ</div>
                    <div class="balance-value">৳<?php echo e(number_format(auth()->user()->vipInvestments()->sum('amount'), 2)); ?></div>
                </div>
                <div class="balance-item">
                    <div class="balance-label">উপলভ্য ব্যালেন্স</div>
                    <div class="balance-value">৳<?php echo e(number_format(auth()->user()->balance, 2)); ?></div>
                </div>
            </div>
        </div>
    </header>

    <main class="main-content">
        <div class="container">
            <div class="page-header">
                <h1 class="page-title">ভিআইপি পণ্য বিভাগ</h1>
                <p class="page-subtitle">প্রিমিয়াম বিনিয়োগের সুযোগ</p>
            </div>
            
            <div class="tab-navigation">
               <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <button class="tab-btn <?php echo e($index === 0 ? 'active' : ''); ?>" data-tab="tab-<?php echo e($category->id); ?>">
        <i class="fas fa-<?php echo e($category->icon); ?>"></i>
        <span><?php echo e($category->display_name); ?></span>
    </button>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <div class="products-container">
                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="tab-content <?php echo e($index === 0 ? 'active' : ''); ?>" id="tab-<?php echo e($category->id); ?>">
                    <div class="products-grid">
                    <?php $__currentLoopData = $category->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="inline-vip-card">
    <div class="inline-card-header">
        <span class="inline-badge"><?php echo e($category->display_name); ?></span>
        <h3 class="inline-title"><?php echo e($product->investment_tool); ?></h3>
        <?php if($product->is_featured): ?>
        <span class="inline-featured">ফিচার্ড</span>
        <?php endif; ?>
        <span class="inline-status <?php echo e($product->is_active ? 'active' : 'inactive'); ?>"></span>
    </div>

    <div class="inline-details">
        <div class="inline-row">
            <span class="inline-label">পণ্যের মূল্য:</span>
            <span class="inline-value">৳<?php echo e(number_format($product->price, 2)); ?></span>
        </div>
        <div class="inline-row">
            <span class="inline-label">দৈনিক আয়:</span>
            <span class="inline-value">৳<?php echo e(number_format($product->earnings_per_user, 2)); ?></span>
        </div>
        <div class="inline-row">
            <span class="inline-label">মেয়াদকাল:</span>
            <span class="inline-value"><?php echo e($product->duration_days); ?> দিন</span>
        </div>
    </div>

    <?php if($product->features): ?>
    <div class="inline-features">
        <div class="inline-features-title">বিশেষ সুবিধা:</div>
        <div class="inline-features-text"><?php echo nl2br(e($product->features)); ?></div>
    </div>
    <?php endif; ?>

    <div class="inline-action">
    <?php
    $userInvestment = auth()->user()->vipInvestments()
        ->where('vip_product_id', $product->id)
        ->first();
?>

<?php if($userInvestment): ?>
    <div class="inline-invested">
        <i class="fas fa-ban"></i>
        <span>আপনি এই পণ্যটি ইতিমধ্যে কিনেছেন<br><small>প্রতিটি ভিআইপি পণ্য শুধুমাত্র একবার কেনা যায়</small></span>
    </div>
<?php elseif(!$product->is_active): ?>
    <button class="inline-btn disabled" disabled>
        <i class="fas fa-lock"></i> পণ্য অপ্রাপ্য
    </button>
<?php elseif($product->price > auth()->user()->balance): ?>
    <button class="inline-btn disabled" disabled>
        <i class="fas fa-lock"></i> ব্যালেন্স অপর্যাপ্ত
    </button>
<?php else: ?>
    <form action="<?php echo e(route('vip.invest', $product)); ?>" method="POST" class="investment-form">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="amount" value="<?php echo e($product->price); ?>">
        <button type="submit" class="inline-btn invest">
            <i class="fas fa-coins"></i> বিনিয়োগ করুন
        </button>
    </form>
<?php endif; ?>
    </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            
            <!-- Active Investments Section -->
            <div class="active-investments">
                <h2 class="section-title">আপনার সক্রিয় বিনিয়োগ</h2>
                
                <?php if($activeInvestments->count() > 0): ?>
                    <div class="investments-grid">
                        <?php $__currentLoopData = $activeInvestments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $investment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="investment-card slide-up" style="animation-delay: <?php echo e($loop->index * 0.1); ?>s">
                            <div class="investment-header">
                                <h3><?php echo e($investment->product->investment_tool); ?></h3>
                              <span class="days-remaining">
    <?php echo e(now()->diffInDays($investment->expires_at)); ?> দিন বাকি
</span>
                            </div>
                            <div class="investment-details">
                                <div class="detail-row">
                                    <span>বিনিয়োগ পরিমাণ:</span>
                                    <strong><?php echo e(number_format($investment->amount, 2)); ?>৳</strong>
                                </div>
                                <div class="detail-row">
                                    <span>দৈনিক আয়:</span>
                                    <strong><?php echo e(number_format($investment->daily_earnings, 2)); ?>৳</strong>
                                </div>
                                <div class="detail-row">
                                    <span>মোট আয়:</span>
                                    <strong><?php echo e(number_format($investment->totalEarnings(), 2)); ?>৳</strong>
                                </div>
                                <div class="detail-row">
                                    <span>শুরু তারিখ:</span>
                                    <strong><?php echo e($investment->created_at->format('d M Y')); ?></strong>
                                </div>
                                <div class="detail-row">
                                    <span>শেষ তারিখ:</span>
                                    <strong><?php echo e($investment->expires_at->format('d M Y')); ?></strong>
                                </div>
                                <div class="detail-row">
                                    <span>পরবর্তী আয়:</span>
                                    <strong>
                                        <?php if($investment->last_payout_at): ?>
                                            <?php echo e($investment->last_payout_at->addDay()->format('h:i A')); ?>

                                        <?php else: ?>
                                            আজ
                                        <?php endif; ?>
                                    </strong>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php else: ?>
                    <div class="no-investments fade-in">
                        <i class="fas fa-info-circle"></i>
                        <p>আপনার কোনো সক্রিয় বিনিয়োগ নেই</p>
                        <p class="mt-2">ভিআইপি পণ্য নির্বাচন করে এখনই বিনিয়োগ শুরু করুন</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </main>
</div>

    <!-- Footer Menu -->
    <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Success Modal -->
    <div class="modal-overlay" id="successModal">
        <div class="modal-content">
            <i class="fas fa-check-circle modal-icon success"></i>
            <h3 class="modal-title">বিনিয়োগ সফল!</h3>
            <p class="modal-message" id="successMessage"></p>
            <button class="modal-btn" id="successModalClose">ঠিক আছে</button>
        </div>
    </div>

    <!-- Error Modal -->
    <div class="modal-overlay" id="errorModal">
        <div class="modal-content">
            <i class="fas fa-times-circle modal-icon error"></i>
            <h3 class="modal-title">ত্রুটি!</h3>
            <p class="modal-message" id="errorMessage"></p>
            <button class="modal-btn" id="errorModalClose">ঠিক আছে</button>
        </div>
    </div>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    // ট্যাব সুইচিং ফাংশনালিটি
    document.querySelectorAll('.tab-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            document.querySelectorAll('.tab-btn').forEach(tab => tab.classList.remove('active'));
            document.querySelectorAll('.tab-content').forEach(content => content.classList.remove('active'));
            this.classList.add('active');
            const tabId = this.getAttribute('data-tab');
            document.getElementById(tabId).classList.add('active');
        });
    });

    // বিনিয়োগ ফর্ম সাবমিশন হ্যান্ডলিং
    document.querySelectorAll('.investment-form').forEach(form => {
        form.addEventListener('submit', async function(e) {
            e.preventDefault();

            const button = this.querySelector('.invest');
            const originalText = button.innerHTML;
            button.innerHTML = '<div class="spinner"></div> প্রসেসিং...';
            button.disabled = true;

            try {
                const response = await fetch(this.action, {
                    method: 'POST',
                    body: new FormData(this),
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
                        'Accept': 'application/json',
                    }
                });

                const data = await response.json();

                if (!response.ok) {
                    // যদি আগেই কিনে থাকেন
                    if (data.already_purchased) {
                        const actionDiv = this.closest('.inline-action');
                        actionDiv.innerHTML = `
                            <button class="inline-btn disabled already-purchased" disabled>
                                <i class="fas fa-ban"></i> ইতিমধ্যে ক্রয়কৃত
                            </button>
                        `;
                        throw new Error(data.message);
                    }

                    // ব্যালেন্স কম হলে
                    if (data.balance_shortage) {
                        const actionDiv = this.closest('.inline-action');
                        actionDiv.innerHTML = `
                            <button class="inline-btn disabled" disabled>
                                <i class="fas fa-lock"></i> ব্যালেন্স অপর্যাপ্ত
                            </button>
                        `;
                        throw new Error(data.message);
                    }

                    throw new Error(data.message || 'বিনিয়োগ ব্যর্থ হয়েছে');
                }

                // বিনিয়োগ সফল হলে UI আপডেট করুন
                const actionDiv = this.closest('.inline-action');
                actionDiv.innerHTML = `
                    <div class="inline-invested">
                        <i class="fas fa-check-circle"></i> 
                        বিনিয়োগকৃত (${data.investment.expires_at})
                    </div>
                `;

                // ব্যালেন্স আপডেট করুন
                const balanceElements = document.querySelectorAll('.balance-value');
                if (balanceElements.length >= 2) {
                    // উপলভ্য ব্যালেন্স আপডেট
                    balanceElements[1].textContent = '৳' + parseFloat(data.balance).toLocaleString('en-US');

                    // মোট বিনিয়োগ আপডেট
                    const currentInvestment = parseFloat(balanceElements[0].textContent.replace('৳', '').replace(/,/g, '')) || 0;
                    const newInvestment = currentInvestment + parseFloat(this.querySelector('input[name="amount"]').value);
                    balanceElements[0].textContent = '৳' + newInvestment.toLocaleString('en-US');
                }

                // সফলতা মেসেজ দেখান
                document.getElementById('successMessage').textContent = data.message;
                document.getElementById('successModal').classList.add('active');

            } catch (error) {
                // এরর হ্যান্ডলিং
                document.getElementById('errorMessage').textContent = error.message;
                document.getElementById('errorModal').classList.add('active');

                // শুধুমাত্র সাধারণ এররের ক্ষেত্রে বাটন রিসেট করুন
                if (!error.message.includes('ইতিমধ্যে') && !error.message.includes('ব্যালেন্স')) {
                    button.innerHTML = originalText;
                    button.disabled = false;
                }
            }
        });
    });

    // মোডাল বন্ধ করার ফাংশন
    document.getElementById('successModalClose').addEventListener('click', function() {
        document.getElementById('successModal').classList.remove('active');
    });

    document.getElementById('errorModalClose').addEventListener('click', function() {
        document.getElementById('errorModal').classList.remove('active');
    });

    // পেজ লোড হলে প্রথম ট্যাব সক্রিয় করুন
    document.addEventListener('DOMContentLoaded', function() {
        const firstTab = document.querySelector('.tab-btn');
        if (firstTab) {
            firstTab.click();
        }
    });
</script>
</body>
</html><?php /**PATH /home/ctrapple/public_html/resources/views/user/investments/index.blade.php ENDPATH**/ ?>