<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title> Admin Dashboard</title>
   <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta
      content="width=device-width, initial-scale=1.0, shrink-to-fit=no"
      name="viewport"
    />
    <link
      rel="icon"
      href="<?php echo e(asset('Backend/assets/img/kaiadmin/favicon.ico')); ?>"
      type="image/x-icon"
    />

    <!-- Fonts and icons -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/webfont/webfont.min.js')); ?>"></script>
    <script>
      WebFont.load({
        google: { families: ["Public Sans:300,400,500,600,700"] },
        custom: {
          families: [
            "Font Awesome 5 Solid",
            "Font Awesome 5 Regular",
            "Font Awesome 5 Brands",
            "simple-line-icons",
          ],
          urls: ["<?php echo e(asset('Backend/assets/css/fonts.min.css')); ?>"],
        },
        active: function () {
          sessionStorage.fonts = true;
        },
      });
    </script>

    <!-- CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('Backend/assets/css/bootstrap.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('Backend/assets/css/plugins.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('Backend/assets/css/kaiadmin.min.css')); ?>" />

    <!-- CSS Just for demo purpose, don't include it in your project -->
    <link rel="stylesheet" href="<?php echo e(asset('Backend/assets/css/demo.css')); ?>" />
  </head>
  <body>
    <div class="wrapper">
      <!-- Sidebar -->
      <div class="sidebar" data-background-color="dark">
        <div class="sidebar-logo">
          <!-- Logo Header -->
          <div class="logo-header" data-background-color="dark">
            <a href="index.html" class="logo">
              <img
                src="<?php echo e(asset(\App\Models\Setting::getValue('site_logo'))); ?>"
                alt="navbar brand"
                class="navbar-brand"
                height="20"
              />
            </a>
            <div class="nav-toggle">
              <button class="btn btn-toggle toggle-sidebar">
                <i class="gg-menu-right"></i>
              </button>
              <button class="btn btn-toggle sidenav-toggler">
                <i class="gg-menu-left"></i>
              </button>
            </div>
            <button class="topbar-toggler more">
              <i class="gg-more-vertical-alt"></i>
            </button>
          </div>
          <!-- End Logo Header -->
        </div>
        <div class="sidebar-wrapper scrollbar scrollbar-inner">
          <div class="sidebar-content">
            <ul class="nav nav-secondary">
             <li class="nav-item <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>">
  <a href="<?php echo e(route('admin.dashboard')); ?>">
    <i class="fas fa-home"></i>
    <p>Dashboard</p>
    <span class="caret"></span>
  </a>
</li>

<li class="nav-item">
    <a data-bs-toggle="collapse" href="#vip-process" aria-expanded="false">
        <i class="fas fa-money-bill-wave"></i>
        <p>ভিআইপি আয় প্রসেস</p>
        <span class="caret"></span>
    </a>
    <div class="collapse" id="vip-process">
        <ul class="nav nav-collapse">
            <!-- আয় প্রসেস করুন -->
            <li>
                <a href="<?php echo e(route('admin.vip.process-earnings')); ?>" 
                   onclick="event.preventDefault(); document.getElementById('process-form').submit();">
                    <span class="sub-item">আয় প্রসেস করুন</span>
                </a>
                <form id="process-form" action="<?php echo e(route('admin.vip.process-earnings')); ?>" method="POST" style="display: none;">
                    <?php echo csrf_field(); ?>
                </form>
            </li>

            <!-- ভিআইপি পেন্ডিং আয় -->
            <li>
                <a href="<?php echo e(route('admin.vip.pending-earnings')); ?>">
                    <span class="sub-item">ভিআইপি পেন্ডিং আয়</span>
                </a>
            </li>
        </ul>
    </div>
</li>



             
              <li class="nav-item">
                <a data-bs-toggle="collapse" href="#base">
                  <i class="fas fa-layer-group"></i>
                  <p>User </p>
                  <span class="caret"></span>
                </a>
                <div class="collapse" id="base">
                  <ul class="nav nav-collapse">
                    <li>
                      <a href="<?php echo e(route('admin.users')); ?>">
                        <span class="sub-item">All Users</span>
                      </a>
                    </li>
                   
                  
                  </ul>
                </div>
              </li>
             <li class="nav-item">
  <a data-bs-toggle="collapse" href="#vipCategories">
    <i class="fas fa-tags"></i>
    <p>VIP Categories</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="vipCategories">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.vip-categories.create')); ?>">
          <span class="sub-item">Add Category</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.vip-categories.index')); ?>">
          <span class="sub-item">All Categories</span>
        </a>
      </li>
    </ul>
  </div>
</li>

<li class="nav-item">
  <a data-bs-toggle="collapse" href="#vipProducts">
    <i class="fas fa-box-open"></i>
    <p>VIP Products</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="vipProducts">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.vip-products.create')); ?>">
          <span class="sub-item">Add Product</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.vip-products.index')); ?>">
          <span class="sub-item">All Products</span>
        </a>
      </li>
    </ul>
  </div>
</li>


<li class="nav-item">
  <a data-bs-toggle="collapse" href="#paymentMethods">
    <i class="fas fa-credit-card"></i>
    <p>Payment Methods</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="paymentMethods">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.payment-methods')); ?>">
          <span class="sub-item">All Methods</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.payment-methods.create')); ?>?add=new">
          <span class="sub-item">Add New Method</span>
        </a>
      </li>
    </ul>
  </div>
</li>
<li class="nav-item">
  <a data-bs-toggle="collapse" href="#transactions">
    <i class="fas fa-exchange-alt"></i>
    <p>Transactions</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="transactions">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.transactions.all')); ?>">
          <span class="sub-item">All Transactions</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.transactions.pending')); ?>">
          <span class="sub-item">Pending</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.transactions.approved')); ?>">
          <span class="sub-item">Approved</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.transactions.rejected')); ?>">
          <span class="sub-item">Rejected</span>
        </a>
      </li>
    </ul>
  </div>
</li>
<li class="nav-item">
  <a data-bs-toggle="collapse" href="#withdraw" aria-expanded="false">
    <i class="fas fa-money-check-alt"></i>
    <p>Withdraw</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="withdraw">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.withdrawals.index')); ?>">
          <span class="sub-item">All Withdrawals</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.withdrawals.pending')); ?>">
          <span class="sub-item">Pending</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.withdrawals.approved')); ?>">
          <span class="sub-item">Approved</span>
        </a>
      </li>
      <li>
        <a href="<?php echo e(route('admin.withdrawals.rejected')); ?>">
          <span class="sub-item">Rejected</span>
        </a>
      </li>
    </ul>
  </div>
</li>

<li class="nav-item">
  <a data-bs-toggle="collapse" href="#support">
    <i class="fas fa-headset"></i>
    <p>Support</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="support">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.support.edit')); ?>">
          <span class="sub-item">Support Settings</span>
        </a>
      </li>
    </ul>
  </div>
</li>

<li class="nav-item">
  <a data-bs-toggle="collapse" href="#about">
    <i class="fas fa-headset"></i>
    <p>About</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="about">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.about.edit')); ?>">
          <span class="sub-item">About Settings</span>
        </a>
      </li>
    </ul>
  </div>
</li>


<li class="nav-item">
  <a data-bs-toggle="collapse" href="#commission">
    <i class="fas fa-percentage"></i>
    <p>Commission</p>
    <span class="caret"></span>
  </a>
  <div class="collapse" id="commission">
    <ul class="nav nav-collapse">
      <li>
        <a href="<?php echo e(route('admin.commissions.edit')); ?>">
          <span class="sub-item">Commission Settings</span>
        </a>
      </li>
    </ul>
  </div>
</li>


            <li class="nav-item">
    <a data-bs-toggle="collapse" href="#settings">
        <i class="fas fa-cog"></i>
        <p>Settings</p>
        <span class="caret"></span>
    </a>
    <div class="collapse" id="settings">
        <ul class="nav nav-collapse">
            <li>
                <a href="<?php echo e(route('admin.settings')); ?>">
                    <span class="sub-item">General Settings</span>
                </a>
            </li>
          
            <li>
                <a href="">
                    <span class="sub-item">Appearance</span>
                </a>
            </li>
        </ul>
    </div>
</li>

<!-- SEO Management Section -->
<li class="nav-item">
    <a data-bs-toggle="collapse" href="#seo-settings">
        <i class="fas fa-search"></i>
        <p>SEO Management</p>
        <span class="caret"></span>
    </a>
    <div class="collapse" id="seo-settings">
        <ul class="nav nav-collapse">
            <li>
                <a href="<?php echo e(route('admin.seo.index')); ?>">
                    <span class="sub-item">All SEO Entries</span>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.seo.global')); ?>">
                    <span class="sub-item">Global SEO Settings</span>
                </a>
            </li>
        </ul>
    </div>
</li>

<!-- Profile Section -->
<li class="nav-item">
    <a data-bs-toggle="collapse" href="#profile-settings">
        <i class="fas fa-user"></i> <!-- Changed icon to user for profile -->
        <p>Profile</p>
        <span class="caret"></span>
    </a>
    <div class="collapse" id="profile-settings">
        <ul class="nav nav-collapse">
            <li>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?php echo e(route('admin.profile')); ?>">
                    <span class="sub-item">My Profile</span>
                </a>
                <div class="dropdown-divider"></div>
                <a class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>">
                    <span class="sub-item">Logout</span>
                </a>
            </li>
        </ul>
    </div>
</li>
              
              
              
            
             
            
            </ul>
          </div>
        </div>
      </div>
      <!-- End Sidebar -->

      <div class="main-panel">
        <div class="main-header">
          <div class="main-header-logo">
            <!-- Logo Header -->
            <div class="logo-header" data-background-color="dark">
              <a href="index.html" class="logo">
                <img
                  src="assets/img/kaiadmin/logo_light.svg"
                  alt="navbar brand"
                  class="navbar-brand"
                  height="20"
                />
              </a>
              <div class="nav-toggle">
                <button class="btn btn-toggle toggle-sidebar">
                  <i class="gg-menu-right"></i>
                </button>
                <button class="btn btn-toggle sidenav-toggler">
                  <i class="gg-menu-left"></i>
                </button>
              </div>
              <button class="topbar-toggler more">
                <i class="gg-more-vertical-alt"></i>
              </button>
            </div>
            <!-- End Logo Header -->
          </div>
          <!-- Navbar Header -->
          <nav
            class="navbar navbar-header navbar-header-transparent navbar-expand-lg border-bottom"
          >
            <div class="container-fluid">
              <nav
                class="navbar navbar-header-left navbar-expand-lg navbar-form nav-search p-0 d-none d-lg-flex"
              >
                <div class="input-group">
                  <div class="input-group-prepend">
                    <button type="submit" class="btn btn-search pe-1">
                      <i class="fa fa-search search-icon"></i>
                    </button>
                  </div>
                  <input
                    type="text"
                    placeholder="Search ..."
                    class="form-control"
                  />
                </div>
              </nav>

              <ul class="navbar-nav topbar-nav ms-md-auto align-items-center">
                <li
                  class="nav-item topbar-icon dropdown hidden-caret d-flex d-lg-none"
                >
                  <a
                    class="nav-link dropdown-toggle"
                    data-bs-toggle="dropdown"
                    href="#"
                    role="button"
                    aria-expanded="false"
                    aria-haspopup="true"
                  >
                    <i class="fa fa-search"></i>
                  </a>
                  <ul class="dropdown-menu dropdown-search animated fadeIn">
                    <form class="navbar-left navbar-form nav-search">
                      <div class="input-group">
                        <input
                          type="text"
                          placeholder="Search ..."
                          class="form-control"
                        />
                      </div>
                    </form>
                  </ul>
                </li>
                <li class="nav-item topbar-icon dropdown hidden-caret">
                  <a
                    class="nav-link dropdown-toggle"
                    href="#"
                    id="messageDropdown"
                    role="button"
                    data-bs-toggle="dropdown"
                    aria-haspopup="true"
                    aria-expanded="false"
                  >
                    <i class="fa fa-envelope"></i>
                  </a>
                  <ul
                    class="dropdown-menu messages-notif-box animated fadeIn"
                    aria-labelledby="messageDropdown"
                  >
                    <li>
                      <div
                        class="dropdown-title d-flex justify-content-between align-items-center"
                      >
                        Messages
                        <a href="#" class="small">Mark all as read</a>
                      </div>
                    </li>
                    <li>
                      <div class="message-notif-scroll scrollbar-outer">
                        <div class="notif-center">
                          <a href="#">
                            <div class="notif-img">
                              <img
                                src="assets/img/jm_denis.jpg"
                                alt="Img Profile"
                              />
                            </div>
                            <div class="notif-content">
                              <span class="subject">Jimmy Denis</span>
                              <span class="block"> How are you ? </span>
                              <span class="time">5 minutes ago</span>
                            </div>
                          </a>
                          <a href="#">
                            <div class="notif-img">
                              <img
                                src="assets/img/chadengle.jpg"
                                alt="Img Profile"
                              />
                            </div>
                            <div class="notif-content">
                              <span class="subject">Chad</span>
                              <span class="block"> Ok, Thanks ! </span>
                              <span class="time">12 minutes ago</span>
                            </div>
                          </a>
                          <a href="#">
                            <div class="notif-img">
                              <img
                                src="assets/img/mlane.jpg"
                                alt="Img Profile"
                              />
                            </div>
                            <div class="notif-content">
                              <span class="subject">Jhon Doe</span>
                              <span class="block">
                                Ready for the meeting today...
                              </span>
                              <span class="time">12 minutes ago</span>
                            </div>
                          </a>
                          <a href="#">
                            <div class="notif-img">
                              <img
                                src="assets/img/talha.jpg"
                                alt="Img Profile"
                              />
                            </div>
                            <div class="notif-content">
                              <span class="subject">Talha</span>
                              <span class="block"> Hi, Apa Kabar ? </span>
                              <span class="time">17 minutes ago</span>
                            </div>
                          </a>
                        </div>
                      </div>
                    </li>
                    <li>
                      <a class="see-all" href="javascript:void(0);"
                        >See all messages<i class="fa fa-angle-right"></i>
                      </a>
                    </li>
                  </ul>
                </li>
               
              

                <li class="nav-item topbar-user dropdown hidden-caret">
                  <a
                    class="dropdown-toggle profile-pic"
                    data-bs-toggle="dropdown"
                    href="#"
                    aria-expanded="false"
                  >
                   
                  <span class="profile-username">
    <span class="fw-bold"><?php echo e(Auth::guard('admin')->user()->name ?? 'Admin'); ?></span>
</span>

                  </a>
                  <ul class="dropdown-menu dropdown-user animated fadeIn">
                    <div class="dropdown-user-scroll scrollbar-outer">
                    
                      <li>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="<?php echo e(route('admin.profile')); ?>">My Profile</a>
                      
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="<?php echo e(route('admin.logout')); ?>">Logout</a>
                      </li>
                    </div>
                  </ul>
                </li>
              </ul>
            </div>
          </nav>
          <!-- End Navbar -->
        </div>

       <?php echo $__env->yieldContent('main'); ?>

      </div>

      <!-- Custom template | don't include it in your project! -->
     
      <!-- End Custom template -->
    </div>
    <!--   Core JS Files   -->
      <script src="<?php echo e(asset('Backend/assets/js/core/jquery-3.7.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Backend/assets/js/core/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Backend/assets/js/core/bootstrap.min.js')); ?>"></script>

    <!-- jQuery Scrollbar -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/jquery-scrollbar/jquery.scrollbar.min.js')); ?>"></script>

    <!-- Chart JS -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/chart.js/chart.min.js')); ?>"></script>

    <!-- jQuery Sparkline -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/jquery.sparkline/jquery.sparkline.min.js')); ?>"></script>

    <!-- Chart Circle -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/chart-circle/circles.min.js')); ?>"></script>

    <!-- Datatables -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/datatables/datatables.min.js')); ?>"></script>

    <!-- Bootstrap Notify -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/bootstrap-notify/bootstrap-notify.min.js')); ?>"></script>

    <!-- jQuery Vector Maps -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/jsvectormap/jsvectormap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Backend/assets/js/plugin/jsvectormap/world.js')); ?>"></script>

    <!-- Sweet Alert -->
    <script src="<?php echo e(asset('Backend/assets/js/plugin/sweetalert/sweetalert.min.js')); ?>"></script>

    <!-- Kaiadmin JS -->
    
    <!-- Kaiadmin JS -->
    <script src="<?php echo e(asset('Backend/assets/js/kaiadmin.min.js')); ?>"></script>

    <!-- Kaiadmin DEMO methods, don't include it in your project! -->
    <script src="<?php echo e(asset('Backend/assets/js/setting-demo.js')); ?>"></script>
    <script>
      $("#lineChart").sparkline([102, 109, 120, 99, 110, 105, 115], {
        type: "line",
        height: "70",
        width: "100%",
        lineWidth: "2",
        lineColor: "#177dff",
        fillColor: "rgba(23, 125, 255, 0.14)",
      });

      $("#lineChart2").sparkline([99, 125, 122, 105, 110, 124, 115], {
        type: "line",
        height: "70",
        width: "100%",
        lineWidth: "2",
        lineColor: "#f3545d",
        fillColor: "rgba(243, 84, 93, .14)",
      });

      $("#lineChart3").sparkline([105, 103, 123, 100, 95, 105, 115], {
        type: "line",
        height: "70",
        width: "100%",
        lineWidth: "2",
        lineColor: "#ffa534",
        fillColor: "rgba(255, 165, 52, .14)",
      });
    </script>
  </body>
</html>
<?php /**PATH /home/ctrapple/public_html/resources/views/admin/admin_master.blade.php ENDPATH**/ ?>