
<?php $__env->startSection('main'); ?>
<div class="container-fluid">
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h4>
                    <i class="fas fa-edit me-2"></i>
                    Edit Payment Method
                </h4>
            </div>
            <div class="col-auto">
                <a href="<?php echo e(route('admin.payment-methods')); ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-1"></i> Back to List
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-8 mx-auto">
            <div class="card">
                <div class="card-body">
                    <form method="POST" action="<?php echo e(route('admin.payment-methods.update', $method->id)); ?>" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label">Method Name</label>
                                <input type="text" class="form-control" name="name" 
                                       value="<?php echo e(old('name', $method->name)); ?>" required>
                                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Account Number</label>
                                <input type="text" class="form-control" name="account_number" 
                                       value="<?php echo e(old('account_number', $method->account_number)); ?>" required>
                                <?php $__errorArgs = ['account_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" rows="3" required><?php echo e(old('description', $method->description)); ?></textarea>
                            <?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3">
                            <label class="form-label">Current Icon</label>
                            <?php if($method->icon): ?>
                                <div class="mb-2">
                                    <img src="<?php echo e(asset($method->icon)); ?>" alt="<?php echo e($method->name); ?>" 
                                         style="width: 60px; height: 60px; object-fit: contain;">
                                    <a href="#" class="btn btn-sm btn-danger ms-2" id="removeIcon">
                                        <i class="fas fa-trash"></i> Remove
                                    </a>
                                    <input type="hidden" name="remove_icon" id="removeIconInput" value="0">
                                </div>
                            <?php else: ?>
                                <p class="text-muted">No icon uploaded</p>
                            <?php endif; ?>
                            
                            <label class="form-label">Change Icon (Optional)</label>
                            <input type="file" class="form-control" name="icon" accept="image/*">
                            <small class="text-muted">Recommended: 100x100px PNG with transparent background</small>
                            <?php $__errorArgs = ['icon'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="mb-3 form-check form-switch">
                            <input type="checkbox" class="form-check-input" name="is_active" 
                                   id="is_active" <?php echo e($method->is_active ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">Active</label>
                        </div>

                        <div class="d-flex justify-content-between mt-4">
                            <button type="button" class="btn btn-danger delete-method" 
                                    data-id="<?php echo e($method->id); ?>">
                                <i class="fas fa-trash me-1"></i> Delete Method
                            </button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-1"></i> Update Method
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Delete</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete this payment method? This action cannot be undone.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form id="deleteForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger">Delete</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    // Remove icon functionality
    $('#removeIcon').click(function(e) {
        e.preventDefault();
        $(this).addClass('d-none');
        $('#removeIconInput').val('1');
        $('input[name="icon"]').val('');
    });

    // Delete method
    $('.delete-method').click(function() {
        let methodId = $(this).data('id');
        $('#deleteForm').attr('action', "<?php echo e(route('admin.payment-methods.destroy', '')); ?>/" + methodId);
        $('#deleteModal').modal('show');
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/payment-methods/edit.blade.php ENDPATH**/ ?>