<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>টিম ড্যাশবোর্ড - বিনিয়োগ প্ল্যাটফর্ম</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;}a{
    text-decoration: none;}body {
    font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    background: #000000;
    color: #ffffff;
    line-height: 1.6;
    padding-bottom: 80px;
    overflow-x: hidden;}/* Header Styles */.header {
    background: #000000;
    padding: 20px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    position: sticky;
    top: 0;
    z-index: 100;}.header-content {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;
    display: flex;
    justify-content: space-between;
    align-items: center;}.user-info {
    display: flex;
    gap: 30px;
    align-items: center;}.uid-section,.refer-section {
    display: flex;
    align-items: center;
    gap: 12px;}.uid-section i,.refer-section i {
    font-size: 20px;
    color: #4CAF50;}.uid-details,.refer-details {
    display: flex;
    flex-direction: column;}.uid-label,.refer-label {
    font-size: 12px;
    color: #cccccc;
    margin-bottom: 2px;}.uid-value,.refer-value {
    font-size: 16px;
    font-weight: 600;
    color: #ffffff;}.copy-btn {
    background: rgba(76, 175, 80, 0.2);
    border: 1px solid #4CAF50;
    color: #4CAF50;
    padding: 8px;
    border-radius: 8px;
    cursor: pointer;
    transition: all 0.3s ease;}.copy-btn:hover {
    background: #4CAF50;
    color: #000000;}.refresh-btn {
    background: rgba(255, 255, 255, 0.1);
    padding: 12px;
    border-radius: 10px;
    cursor: pointer;
    transition: all 0.3s ease;}.refresh-btn:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: rotate(180deg);}.refresh-btn i {
    font-size: 18px;
    color: #ffffff;}/* Main Content */.main-content {
    padding: 30px 0;}.container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 0 20px;}/* Metrics Section */.metrics-section {
    margin-bottom: 30px;}.metrics-box {
    background: linear-gradient(135deg, #000000 0%, #000000 100%);
    border-radius: 20px;
    padding: 30px;
    box-shadow: 0 8px 30px rgba(76, 175, 80, 0.3);}.metrics-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 25px;}.metrics-header i {
    font-size: 24px;
    color: #ffffff;}.metrics-header h2 {
    font-size: 24px;
    font-weight: 700;
    color: #ffffff;}.metrics-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 25px;}.metric-item {
    display: flex;
    align-items: center;
    gap: 15px;
    background: rgba(0, 0, 0, 0.1);
    padding: 20px;
    border-radius: 15px;}.metric-icon {
    background: rgba(0, 0, 0, 0.2);
    padding: 12px;
    border-radius: 12px;}.metric-icon i {
    font-size: 20px;
    color: #ffffff;}.metric-content {
    display: flex;
    flex-direction: column;}.metric-label {
    font-size: 14px;
    color: rgba(255, 255, 255, 0.8);
    margin-bottom: 5px;}.metric-value {
    font-size: 24px;
    font-weight: 700;
    color: #ffffff;}/* Expand Section */.expand-section {
    margin-bottom: 40px;
    text-align: center;}.expand-btn {
    background: linear-gradient(135deg, #2196F3 0%, #1976D2 100%);
    color: #ffffff;
    border: none;
    padding: 18px 40px;
    border-radius: 50px;
    font-size: 18px;
    font-weight: 600;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    gap: 15px;
    transition: all 0.3s ease;
    box-shadow: 0 6px 20px rgba(33, 150, 243, 0.3);}.expand-btn:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 30px rgba(33, 150, 243, 0.4);}.expand-btn i {
    font-size: 20px;}/* Info Boxes Section */.info-boxes-section {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 25px;
    margin-bottom: 40px;}.info-box {
    background: #1a1a1a;
    border-radius: 20px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.3s ease;}.info-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(255, 255, 255, 0.1);
    border-color: rgba(255, 255, 255, 0.2);}.info-header {
    display: flex;
    align-items: center;
    justify-content: space-between;
    margin-bottom: 20px;}.info-icon {
    font-size: 24px;
    color: #4CAF50;}.info-title {
    font-size: 18px;
    font-weight: 600;
    color: #ffffff;
    flex: 1;
    margin-left: 15px;}.info-badge {
    background: rgba(76, 175, 80, 0.2);
    color: #4CAF50;
    padding: 6px 12px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;}.info-stats {
    display: flex;
    justify-content: space-around;
    gap: 20px;}.stat-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-align: center;}.stat-number {
    font-size: 28px;
    font-weight: 700;
    color: #ffffff;
    margin-bottom: 5px;}.stat-label {
    font-size: 14px;
    color: #cccccc;
    font-weight: 600;
    background: rgba(255, 255, 255, 0.1);
    padding: 4px 12px;
    border-radius: 15px;}/* Policy Sections */.policy-section {
    background: #1a1a1a;
    border-radius: 20px;
    padding: 30px;
    margin-bottom: 30px;
    border: 1px solid rgba(255, 255, 255, 0.1);}.policy-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 25px;
    padding-bottom: 15px;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);}.policy-header i {
    font-size: 24px;
    color: #4CAF50;}.policy-header h2 {
    font-size: 24px;
    font-weight: 700;
    color: #ffffff;}.policy-content {
    color: #cccccc;}.policy-list {
    list-style: none;}.policy-item {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 15px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.05);}.policy-item:last-child {
    border-bottom: none;}.policy-item i {
    color: #4CAF50;
    font-size: 16px;}.policy-item span {
    font-size: 16px;
    line-height: 1.6;}/* Level Grid */.level-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 20px;}.level-card {
    background: #2a2a2a;
    border-radius: 15px;
    padding: 25px;
    border: 1px solid rgba(255, 255, 255, 0.1);
    transition: all 0.3s ease;}.level-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(255, 255, 255, 0.1);
    border-color: #4CAF50;}.level-header {
    display: flex;
    align-items: center;
    gap: 15px;
    margin-bottom: 20px;}.level-badge {
    background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);
    color: #000000;
    padding: 8px 16px;
    border-radius: 20px;
    font-size: 14px;
    font-weight: 700;}.level-title {
    font-size: 18px;
    font-weight: 600;
    color: #ffffff;}.level-details {
    display: flex;
    flex-direction: column;
    gap: 15px;}.level-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 12px 0;
    border-bottom: 1px solid rgba(255, 255, 255, 0.1);}.level-item:last-child {
    border-bottom: none;}.level-label {
    font-size: 14px;
    color: #cccccc;}.level-value {
    font-size: 16px;
    font-weight: 600;
    color: #4CAF50;}/* Bottom Navigation */.bottom-nav {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: #1a1a1a;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    box-shadow: 0 -2px 20px rgba(0, 0, 0, 0.3);
    z-index: 1000;}.nav-content {
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 15px 20px;
    max-width: 1200px;
    margin: 0 auto;}.nav-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: #cccccc;
    transition: all 0.3s ease;
    padding: 8px 15px;
    border-radius: 12px;
    min-width: 70px;}.nav-item:hover,.nav-item.active {
    color: #4CAF50;
    background: rgba(76, 175, 80, 0.1);}.nav-icon {
    font-size: 20px;
    margin-bottom: 5px;}.nav-text {
    font-size: 12px;
    font-weight: 500;}/* Toast Notification */.toast {
    position: fixed;
    top: 20px;
    right: 20px;
    background: #4CAF50;
    color: #000000;
    padding: 15px 20px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    gap: 10px;
    font-weight: 600;
    transform: translateX(400px);
    transition: all 0.3s ease;
    z-index: 1001;
    box-shadow: 0 4px 20px rgba(76, 175, 80, 0.3);}.toast.show {
    transform: translateX(0);}.toast i {
    font-size: 18px;}/* Responsive Design */@media (max-width: 768px) {
    .header-content {
        flex-direction: column;
        gap: 20px;
    }
    .user-info {
        flex-direction: column;
        gap: 15px;
        text-align: center;
    }
    .metrics-grid {
        grid-template-columns: 1fr;
    }
    .info-boxes-section {
        grid-template-columns: 1fr;
    }
    .level-grid {
        grid-template-columns: 1fr;
    }
    .container {
        padding: 0 15px;
    }
    .expand-btn {
        padding: 15px 30px;
        font-size: 16px;
    }}@media (max-width: 480px) {
    .metrics-box {
        padding: 20px;
    }
    .metric-item {
        padding: 15px;
    }
    .metric-value {
        font-size: 20px;
    }
    .info-box,
    .policy-section,
    .level-card {
        padding: 20px;
    }
    .nav-content {
        padding: 12px 15px;
    }
    .nav-item {
        min-width: 60px;
        padding: 6px 10px;
    }
    .nav-icon {
        font-size: 18px;
    }
    .nav-text {
        font-size: 11px;
    }
    .toast {
        right: 15px;
        left: 15px;
        transform: translateY(-100px);
    }
    .toast.show {
        transform: translateY(0);
    }}/* Loading Animation */.loading {
    opacity: 0;
    transform: translateY(30px);
    transition: all 0.6s ease;}.loading.loaded {
    opacity: 1;
    transform: translateY(0);}/* Smooth Scrolling */html {
    scroll-behavior: smooth;}/* Custom Scrollbar */::-webkit-scrollbar {
    width: 8px;}::-webkit-scrollbar-track {
    background: #1a1a1a;}::-webkit-scrollbar-thumb {
    background: #4CAF50;
    border-radius: 4px;}::-webkit-scrollbar-thumb:hover {
    background: #45a049;}/* Footer Menu */.footer-menu {
    position: fixed;
    bottom: 0;
    left: 0;
    right: 0;
    background: #1a1a1a;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
    z-index: 1000;}.footer-content {
    display: flex;
    justify-content: space-around;
    align-items: center;
    padding: 15px 20px;
    max-width: 1200px;
    margin: 0 auto;}.footer-item {
    display: flex;
    flex-direction: column;
    align-items: center;
    text-decoration: none;
    color: #cccccc;
    transition: all 0.3s ease;
    padding: 8px;
    border-radius: 10px;}.footer-item:hover,.footer-item.active {
    color: #ffffff;
    background: rgba(255, 255, 255, 0.1);}.footer-icon {
    font-size: 20px;
    margin-bottom: 5px;}.footer-text {
    font-size: 12px;
    font-weight: 500;}
    </style>
</head>
<body>
    <!-- Header Section -->
    <header class="header">
        <div class="header-content">
            <div class="user-info">
                <div class="uid-section">
                    <i class="fas fa-id-card"></i>
                    <div class="uid-details">
                        <span class="uid-label">ইউআইডি</span>
                       <span class="uid-value"><?php echo e(auth()->user()->id); ?></span>
                    </div>
                </div>
                <div class="refer-section">
                    <i class="fas fa-share-alt"></i>
                    <div class="refer-details">
                        <span class="refer-label">রেফারেল কোড</span>
                        <span class="refer-value"><?php echo e(auth()->user()->referral_code); ?></span>
                    </div>
                    <button class="copy-btn" onclick="copyReferralCode()" aria-label="রেফারেল কোড কপি করুন">
                        <i class="fas fa-copy"></i>
                    </button>
                </div>
            </div>
            <div class="refresh-btn" aria-label="রিফ্রেশ করুন">
                <i class="fas fa-sync-alt"></i>
            </div>
        </div>
    </header>
    <!-- Main Content -->
    <main class="main-content">
        <div class="container">
            <!-- Team Metrics Section -->
            <div class="metrics-section">
                <div class="metrics-box">
                    <div class="metrics-header">
                        <i class="fas fa-users"></i>
                        <h2>টিম পারফরম্যান্স</h2>
                    </div>
                    <div class="metrics-grid">
                        <div class="metric-item">
                            <div class="metric-icon">
                                <i class="fas fa-dollar-sign"></i>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label">টিম আয়</span>
                                <span class="metric-value">৳<?php echo e(number_format($teamEarnings, 2)); ?></span>
                            </div>
                        </div>
                        <div class="metric-item">
                            <div class="metric-icon">
                                <i class="fas fa-hashtag"></i>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label">মোট সংখ্যা</span>
                               <span class="metric-value"><?php echo e($totalReferrals); ?></span>
                            </div>
                        </div>
                        <div class="metric-item">
                            <div class="metric-icon">
                                <i class="fas fa-chart-line"></i>
                            </div>
                            <div class="metric-content">
                                <span class="metric-label">আজকের লাভ</span>
                                <span class="metric-value">৳<?php echo e($todayEarnings > 0 ? number_format($todayEarnings, 2) : '0.00'); ?></span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
           
            <!-- Info Boxes Section -->
            <div class="info-boxes-section">
                <div class="info-box">
                    <div class="info-header">
                        <i class="fas fa-user-plus info-icon"></i>
                        <h3 class="info-title">মোট রেজিস্ট্রেশন</h3>
                          <span class="info-badge"><?php echo e($totalTeamMembers); ?>  মোট</span>
                    </div>
                     <div class="info-stats">
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($level1Count); ?></span>
                            <span class="stat-label">লেভেল 1</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($level2Count); ?></span>
                            <span class="stat-label">লেভেল 2</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($level3Count); ?></span>
                            <span class="stat-label">লেভেল 3</span>
                        </div>
                    </div>
                </div>
                <div class="info-box">
                <div class="info-header">
    <i class="fas fa-piggy-bank info-icon"></i>
    <h3 class="info-title">টিম ডিপোজিট</h3>
    <span class="info-badge">
        ৳<?php echo e(rtrim(rtrim(number_format($teamDeposits, 3, '.', ','), '0'), '.')); ?> মোট
    </span>
</div>
                     <div class="info-stats">
                        <div class="stat-item">
                            <span class="stat-number">৳<?php echo e(rtrim(rtrim(number_format($teamDeposits, 3, '.', ','), '0'), '.')); ?></span>
                            <span class="stat-label">লেভেল 1</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">৳<?php echo e(number_format($level2Deposits, 2)); ?></span>
                            <span class="stat-label">লেভেল 2</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number">৳<?php echo e(number_format($level3Deposits, 2)); ?></span>
                            <span class="stat-label">লেভেল 3</span>
                        </div>
                    </div>
                </div>
                <div class="info-box">
                    <div class="info-header">
                        <i class="fas fa-handshake info-icon"></i>
                        <h3 class="info-title">মোট রেফারেল</h3>
                        <span class="info-badge"><?php echo e($totalReferrals); ?> মোট</span>
                    </div>
                    <div class="info-stats">
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($activeMembers); ?></span>
                            <span class="stat-label">সক্রিয়</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($inactiveMembers); ?></span>
                            <span class="stat-label">নিষ্ক্রিয়</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-number"><?php echo e($vipMembers); ?></span>
                            <span class="stat-label">ভিআইপি</span>
                        </div>
                    </div>
                </div>
            </div>
            <!-- Commission Policy Section -->
            <div class="policy-section">
                <div class="policy-header">
                    <i class="fas fa-percentage"></i>
                    <h2>কমিশন নীতি</h2>
                </div>
                <div class="policy-content">
                    <ul class="policy-list">
                       <?php if($commission && $commission->description): ?>
                <?php $__currentLoopData = explode("\n", $commission->description); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if(trim($policy)): ?>
                        <li class="policy-item">
                            <i class="fas fa-check-circle"></i>
                            <span><?php echo e(trim($policy)); ?></span>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
                <li class="policy-item">
                    <i class="fas fa-info-circle"></i>
                    <span>কমিশন নীতি এখনো সংজ্ঞায়িত করা হয়নি</span>
                </li>
            <?php endif; ?>
                    </ul>
                </div>
            </div>
            <!-- Level Policy Section -->
            <div class="policy-section">
                <div class="policy-header">
                    <i class="fas fa-layer-group"></i>
                    <h2>লেভেল নীতি</h2>
                </div>
                <div class="policy-content">
                    <div class="level-grid">
                        <?php $__currentLoopData = $vipProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="level-card">
                            <div class="level-header">
                                <span class="level-badge"><?php echo e($product->level_name); ?></span>
                                <span class="level-title"><?php echo e($product->investment_tool); ?></span>
                            </div>
                            <div class="level-details">
                                <div class="level-item">
                                    <span class="level-label">বিনিয়োগ</span>
                                    <span class="level-value">৳<?php echo e(number_format($product->price, 2)); ?></span>
                                </div>
                                <div class="level-item">
                                    <span class="level-label">দৈনিক আয়</span>
                                    <span class="level-value">৳<?php echo e(number_format($product->earnings_per_user, 2)); ?></span>
                                </div>
                                <div class="level-item">
                                    <span class="level-label">মোট ফেরত</span>
                                    <span class="level-value">৳<?php echo e(number_format($product->price * 1.35, 2)); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </div>
                </div>
            </div>
        </div>
    </main>
   <?php echo $__env->make('layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Toast Notification -->
    <div class="toast" id="toast">
        <i class="fas fa-check-circle"></i>
        <span>রেফারেল কোড ক্লিপবোর্ডে কপি করা হয়েছে!</span>
    </div>
    <script>
// Copy Referral Code Functionality
function copyReferralCode() {
    const referralCode = 'H31071';
        // Use the Clipboard API if available
    if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(referralCode).then(() => {
            showToast("রেফারেল কোড ক্লিপবোর্ডে কপি করা হয়েছে!");
        }).catch(err => {
            console.error('কপি করতে ব্যর্থ: ', err);
            fallbackCopyTextToClipboard(referralCode);
        });
    } else {
        // Fallback for older browsers
        fallbackCopyTextToClipboard(referralCode);
    }}
// Fallback copy function for older browsers
function fallbackCopyTextToClipboard(text) {
    const textArea = document.createElement('textarea');
    textArea.value = text;
        // Avoid scrolling to bottom
    textArea.style.top = '0';
    textArea.style.left = '0';
    textArea.style.position = 'fixed';
        document.body.appendChild(textArea);
    textArea.focus();
    textArea.select();
        try {
        const successful = document.execCommand('copy');
        if (successful) {
            showToast("রেফারেল কোড ক্লিপবোর্ডে কপি করা হয়েছে!");
        }
    } catch (err) {
        console.error('ফলব্যাক: ওহ, কপি করা যাচ্ছে না', err);
    }
        document.body.removeChild(textArea);}
// Show Toast Notification
function showToast(message) {
    const toast = document.getElementById('toast');
    toast.querySelector('span').textContent = message; // Update toast message
    toast.classList.add('show');
        setTimeout(() => {
        toast.classList.remove('show');
    }, 3000);}
// Bottom Navigation Functionality
function initializeBottomNav() {
    const navItems = document.querySelectorAll('.nav-item');
        navItems.forEach(item => {
        item.addEventListener('click', function(e) {
            e.preventDefault();
                        // Remove active class from all nav items
            navItems.forEach(nav => nav.classList.remove('active'));
                        // Add active class to clicked item
            this.classList.add('active');
                        // Add click animation
            this.style.transform = 'scale(0.9)';
            setTimeout(() => {
                this.style.transform = 'scale(1)';
            }, 150);
        });
    });}
// Expand Team Button Functionality
function initializeExpandButton() {
    const expandBtn = document.querySelector('.expand-btn');
        if (expandBtn) {
        expandBtn.addEventListener('click', function() {
            // Add loading state
            const originalHTML = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>লোড হচ্ছে...</span>';
            this.disabled = true;
                        // Simulate navigation or API call
            setTimeout(() => {
                this.innerHTML = originalHTML;
                this.disabled = false;
                                // Here you would typically navigate to team expansion page
                console.log('টিম সম্প্রসারণ পৃষ্ঠায় নেভিগেট করুন');
            }, 2000);
                        // Add click animation
            this.style.transform = 'scale(0.95)';
            setTimeout(() => {
                this.style.transform = 'scale(1)';
            }, 150);
        });
    }}
// Refresh Button Functionality
function initializeRefreshButton() {
    const refreshBtn = document.querySelector('.refresh-btn');
        if (refreshBtn) {
        refreshBtn.addEventListener('click', function() {
            // Add rotation animation
            this.style.transform = 'rotate(360deg)';
                        // Simulate data refresh
            setTimeout(() => {
                this.style.transform = 'rotate(0deg)';
                updateDashboardData();
            }, 1000);
        });
    }}
// Simulate Dashboard Data Update
function updateDashboardData() {
    // This would typically fetch real data from an API
    const metricValues = document.querySelectorAll('.metric-value');
    const statNumbers = document.querySelectorAll('.stat-number');
        // Add loading animation to values
    [...metricValues, ...statNumbers].forEach(element => {
        element.style.opacity = '0.5';
        element.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
    });
        // Simulate API response delay
    setTimeout(() => {
        // Reset metric values (in real app, this would be actual data)
        metricValues[0].innerHTML = '৳0.00'; // Team Income
        metricValues[1].innerHTML = '0'; // Total Number
        metricValues[2].innerHTML = '৳0.00'; // Today's Profit
                // Reset stat numbers
        statNumbers.forEach(stat => {
            stat.innerHTML = '0';
        });
                // Restore opacity
        [...metricValues, ...statNumbers].forEach(element => {
            element.style.opacity = '1';
        });
                // Show success message
        showToast("ড্যাশবোর্ড সফলভাবে আপডেট হয়েছে!");
    }, 1500);}
// Show Update Toast
function showUpdateToast() {
    const toast = document.createElement('div');
    toast.className = 'toast show';
    toast.innerHTML = '<i class="fas fa-sync-alt"></i><span>ড্যাশবোর্ড সফলভাবে আপডেট হয়েছে!</span>';
    document.body.appendChild(toast);
        setTimeout(() => {
        toast.classList.remove('show');
        setTimeout(() => {
            document.body.removeChild(toast);
        }, 300);
    }, 2000);}
// Card Hover Effects
function initializeCardEffects() {
    const cards = document.querySelectorAll('.info-box, .level-card');
        cards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-8px) scale(1.02)';
        });
                card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0) scale(1)';
        });
    });}
// Loading Animation
function initializeLoadingAnimations() {
    const animatedElements = document.querySelectorAll('.metrics-box, .info-box, .level-card, .policy-section');
        // Add loading class initially
    animatedElements.forEach(element => {
        element.classList.add('loading');
    });
        // Remove loading class with staggered timing
    animatedElements.forEach((element, index) => {
        setTimeout(() => {
            element.classList.add('loaded');
        }, index * 100 + 300);
    });}
// Intersection Observer for Scroll Animations
function initializeScrollAnimations() {
    const observerOptions = {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
    };
    const observer = new IntersectionObserver(function(entries) {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }
        });
    }, observerOptions);
    // Observe elements for animation
    const observeElements = document.querySelectorAll('.info-box, .level-card, .policy-section');
    observeElements.forEach(element => {
        element.style.opacity = '0';
        element.style.transform = 'translateY(30px)';
        element.style.transition = 'all 0.6s ease';
        observer.observe(element);
    });}
// Responsive Menu Handler
function handleResponsiveMenu() {
    const windowWidth = window.innerWidth;
        if (windowWidth <= 768) {
        // Adjust layout for mobile
        const userInfo = document.querySelector('.user-info');
        if (userInfo) {
            userInfo.style.flexDirection = 'column';
            userInfo.style.gap = '15px';
        }
    }}
// Add Ripple Effect to Buttons
function createRippleEffect(event, element) {
    const ripple = document.createElement('span');
    const rect = element.getBoundingClientRect();
    const size = Math.max(rect.width, rect.height);
    const x = event.clientX - rect.left - size / 2;
    const y = event.clientY - rect.top - size / 2;
        ripple.style.cssText = `
        position: absolute;
        width: ${size}px;
        height: ${size}px;
        left: ${x}px;
        top: ${y}px;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 50%;
        transform: scale(0);
        animation: ripple 0.6s linear;
        pointer-events: none;
    `;
        element.style.position = 'relative';
    element.style.overflow = 'hidden';
    element.appendChild(ripple);
        setTimeout(() => {
        ripple.remove();
    }, 600);}
// Add CSS for ripple animation
function addRippleCSS() {
    const style = document.createElement('style');
    style.textContent = `
        @keyframes ripple {
            to {
                transform: scale(4);
                opacity: 0;
            }
        }
    `;
    document.head.appendChild(style);}
// Initialize Counter Animation
function animateCounters() {
    const counters = document.querySelectorAll('.metric-value, .stat-number');
        counters.forEach(counter => {
        const target = parseInt(counter.textContent.replace(/[^0-9]/g, '')) || 0;
        const increment = target / 50;
        let current = 0;
                const timer = setInterval(() => {
            current += increment;
            if (current >= target) {
                counter.textContent = counter.textContent.replace(/[0-9,]+/, target.toLocaleString());
                clearInterval(timer);
            } else {
                counter.textContent = counter.textContent.replace(/[0-9,]+/, Math.floor(current).toLocaleString());
            }
        }, 20);
    });}
// Initialize all functionality when DOM is loaded
document.addEventListener('DOMContentLoaded', function() {
    initializeBottomNav();
    initializeExpandButton();
    initializeRefreshButton();
    initializeCardEffects();
    initializeScrollAnimations();
    addRippleCSS();
        // Add loading animations after a short delay
    setTimeout(initializeLoadingAnimations, 100);
        // Handle window resize
    window.addEventListener('resize', handleResponsiveMenu);
    handleResponsiveMenu();
        // Add ripple effect to buttons
    const buttons = document.querySelectorAll('.expand-btn, .copy-btn');
    buttons.forEach(button => {
        button.addEventListener('click', function(e) {
            createRippleEffect(e, this);
        });
    });});
// Page Load Event
window.addEventListener('load', function() {
    // Animate counters after page load
    setTimeout(animateCounters, 500);
        // Hide any loading screens
    const loadingScreen = document.querySelector('.loading-screen');
    if (loadingScreen) {
        loadingScreen.style.opacity = '0';
        setTimeout(() => {
            loadingScreen.style.display = 'none';
        }, 300);
    }});
// Error Handling
window.addEventListener('error', function(e) {
    console.error('জাভাস্ক্রিপ্ট ত্রুটি:', e.error);});
// Export functions for potential module use
if (typeof module !== 'undefined' && module.exports) {
    module.exports = {
        copyReferralCode,
        showToast,
        initializeBottomNav,
        updateDashboardData
    };}
    </script>
</body>
</html>
<?php /**PATH /home/ctrapple/public_html/resources/views/user/team/index.blade.php ENDPATH**/ ?>