
<?php $__env->startSection('main'); ?>

<div class="container">
    <div class="page-inner">
        <div class="page-header"></div>
        <div class="row">
            <div class="col-md-12">
                <?php if(session('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <?php echo e(session('success')); ?>

                        <?php if(session('new_balance')): ?>
                            <div>New Balance: ৳<?php echo e(number_format(session('new_balance'), 2)); ?></div>
                        <?php endif; ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                    </div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title">User Management</h4>
                        <div class="d-flex">
                            <form action="" method="GET" class="me-2">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Search users..." name="search" value="<?php echo e(request('search')); ?>">
                                    <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                                </div>
                            </form>
                          
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="basic-datatables" class="display table table-striped table-hover">
                                <thead class="bg-light">
                                    <tr>
                                        <th>SL</th>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Phone</th>
                                        <th>Balance</th>
                                        <th>Status</th>
                                        <th>Joined</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr data-user-id="<?php echo e($user->id); ?>">
                                        <td><?php echo e($key + 1); ?></td>
                                        <td>
                                            <?php if($user->image): ?>
                                                <img src="<?php echo e(asset('storage/'.$user->image)); ?>" class="rounded-circle" width="40" height="40" alt="User Image">
                                            <?php else: ?>
                                                <div class="avatar-default rounded-circle d-flex align-items-center justify-content-center" style="width:40px;height:40px;background-color:#f0f0f0;">
                                                    <i class="fas fa-user text-muted"></i>
                                                </div>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->name ?? 'N/A'); ?></td>
                                        <td><?php echo e($user->email ?? 'N/A'); ?></td>
                                        <td><?php echo e($user->phone ?? 'N/A'); ?></td>
                                        <td class="user-balance">৳<?php echo e(number_format($user->balance, 2)); ?></td>
                                        <td>
                                            <?php if($user->status): ?>
                                                <span class="badge bg-success">Active</span>
                                            <?php else: ?>
                                                <span class="badge bg-danger">Inactive</span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($user->created_at->format('d M, Y')); ?></td>
                                        <td>
                                            <div class="btn-group">
                                                <button class="btn btn-sm btn-info update-balance" 
                                                        data-bs-toggle="modal" 
                                                        data-bs-target="#balanceModal-<?php echo e($user->id); ?>"
                                                        title="Update Balance">
                                                    <i class="fas fa-money-bill-wave"></i>
                                                </button>
                                                
                                                <a href="<?php echo e(route('admin.user.status', $user->id)); ?>" class="btn btn-sm btn-warning" title="Toggle Status">
                                                    <i class="fas fa-sync-alt"></i>
                                                </a>
                                                
                                                <form action="<?php echo e(route('admin.user.delete', $user->id)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-sm btn-danger" title="Delete" onclick="return confirm('Are you sure you want to delete this user?')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>

                                    <!-- Balance Update Modal for each user -->
                                    <div class="modal fade" id="balanceModal-<?php echo e($user->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">Update Balance for <?php echo e($user->name); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form action="<?php echo e(route('admin.user.balance.update', $user->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-body">
                                                        <div class="mb-3">
                                                            <label class="form-label">Current Balance</label>
                                                            <input type="text" class="form-control" value="৳<?php echo e(number_format($user->balance, 2)); ?>" readonly>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Amount</label>
                                                            <input type="number" class="form-control" name="amount" required min="0.01" step="0.01" placeholder="Enter amount">
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Action</label>
                                                            <select class="form-select" name="type" required>
                                                                <option value="add">Add to Balance</option>
                                                                <option value="subtract">Subtract from Balance</option>
                                                            </select>
                                                        </div>
                                                        <div class="mb-3">
                                                            <label class="form-label">Notes (Optional)</label>
                                                            <textarea class="form-control" name="notes" rows="2" placeholder="Reason for balance update"></textarea>
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                                                        <button type="submit" class="btn btn-primary">Update Balance</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
    .avatar-default {
        display: inline-flex;
    }
    .table th, .table td {
        vertical-align: middle;
    }
    .btn-group .btn {
        margin-right: 5px;
        border-radius: 4px;
    }
    .badge {
        font-size: 0.8em;
        padding: 0.35em 0.65em;
    }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
$(document).ready(function() {
    // Initialize DataTables
    $('#basic-datatables').DataTable({
        "pageLength": 25,
        "responsive": true,
        "dom": '<"top"f>rt<"bottom"lip><"clear">',
        "language": {
            "search": "_INPUT_",
            "searchPlaceholder": "Search users...",
            "paginate": {
                "previous": "&laquo;",
                "next": "&raquo;"
            }
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/users/index.blade.php ENDPATH**/ ?>