<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>রিচার্জ পেজ</title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <style>
        /* Basic Reset & Body Styles */
        body {
            margin: 0;
            font-family: "Inter", sans-serif;
            min-height: 100vh;
            background: linear-gradient(135deg, #0a0a0a 0%, #1a1a1a 100%);
            color: white;
            display: flex;
            flex-direction: column;
            box-sizing: border-box;
        }
        a {
            text-decoration: none;
        }
        .container {
            display: flex;
            flex-direction: column;
            min-height: 100vh;
            width: 100%;
            max-width: 500px;
            margin: 0 auto;
            background-color: black;
            box-shadow: 0 0 20px rgba(0, 0, 0, 0.3);
        }
        
        /* Header Styles */
        .header {
            background-color: #1a1a1a;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            color: white;
            border-bottom: 1px solid #2a2a2a;
        }
        .icon-button {
            background: none;
            border: none;
            color: white;
            cursor: pointer;
            padding: 0.5rem;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: transform 0.2s ease-in-out;
        }
        .icon-button:hover {
            transform: translateX(-3px);
            color: #22c55e;
        }
        .header-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin: 0;
        }
        
        /* Balance Section */
        .balance-section {
            background-color: #1a1a1a;
            padding: 1.5rem;
            text-align: center;
            margin-bottom: 1rem;
            border-bottom: 1px solid #2a2a2a;
        }
        .balance-label {
            font-size: 1.125rem;
            color: #a0a0a0;
            margin-bottom: 0.5rem;
        }
        .balance-amount {
            font-size: 2.25rem;
            font-weight: 700;
            margin: 0;
            color: #22c55e;
        }
        
        /* Alert Message */
        .alert-message {
            background-color: #2a2a2a;
            padding: 1rem;
            margin: 0 1rem 1rem 1rem;
            border-radius: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            box-shadow: 0 1px 4px rgba(0, 0, 0, 0.1);
        }
        .alert-text {
            font-size: 0.875rem;
            color: #a0a0a0;
            margin: 0;
        }
        
        /* Input Section */
        .input-section {
            padding: 1rem;
            flex-grow: 1;
        }
        .input-group {
            margin-bottom: 1rem;
        }
        .input-label {
            display: block;
            font-size: 0.875rem;
            font-weight: 500;
            margin-bottom: 0.5rem;
            color: #e0e0e0;
        }
        .input-field {
            width: 100%;
            padding: 0.75rem 1rem;
            background-color: #3a3a3a;
            color: white;
            border: 1px solid #5a5a5a;
            border-radius: 0.375rem;
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.2);
            outline: none;
            transition: border-color 0.2s ease-in-out, box-shadow 0.2s ease-in-out;
        }
        .input-field:focus {
            border-color: #22c55e;
            box-shadow: 0 0 0 3px rgba(34, 197, 94, 0.5), inset 0 1px 3px rgba(0, 0, 0, 0.2);
        }
        .input-error-message {
            color: #ef4444;
            font-size: 0.75rem;
            margin-top: 0.25rem;
            min-height: 1rem;
        }
        
        /* Recharge Button */
        .footer {
            padding: 1rem;
        }
        .recharge-button {
            width: 100%;
            background-color: #22c55e;
            color: white;
            padding: 1.5rem;
            font-size: 1.125rem;
            font-weight: 600;
            border: none;
            border-radius: 9999px;
            cursor: pointer;
            transition: background-color 0.2s ease-in-out, transform 0.2s ease-in-out;
            box-shadow: 0 4px 10px rgba(34, 197, 94, 0.4);
        }
        .recharge-button:hover:not(:disabled) {
            background-color: #16a34a;
            transform: translateY(-2px);
        }
        
        /* Modal Styles */
        .modal-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.7);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 1000;
            display: none;
        }
        .modal-content {
            background-color: #1a1a1a;
            padding: 1.5rem;
            border-radius: 0.75rem;
            width: 90%;
            max-width: 400px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.2);
            text-align: center;
        }
        .modal-title {
            font-size: 1.25rem;
            font-weight: 600;
            margin-bottom: 1.5rem;
            color: white;
        }
        .channel-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 1rem;
            margin-bottom: 1.5rem;
        }
        .channel-card {
            background-color: #2a2a2a;
            padding: 1rem 0.5rem;
            border-radius: 0.5rem;
            cursor: pointer;
            transition: all 0.2s ease-in-out;
            border: 2px solid transparent;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        .channel-card.selected {
            border-color: #22c55e;
            background-color: #3a3a3a;
            box-shadow: 0 0 0 2px #22c55e;
        }
        .channel-logo {
            width: 64px;
            height: 64px;
            object-fit: contain;
            margin-bottom: 0.5rem;
        }
        
        /* Payment Details Page */
        .payment-details-page {
            display: none;
            background-color: black;
            color: white;
        }
        .payment-content {
            padding: 1.5rem;
            flex-grow: 1;
            background-color: #1a1a1a;
            margin: 1rem;
            border-radius: 0.75rem;
        }
        .warning-text {
            font-size: 0.875rem;
            color: #ef4444;
            margin-bottom: 1rem;
        }
        .input-with-icon {
            display: flex;
            align-items: center;
            background-color: #3a3a3a;
            border: 1px solid #5a5a5a;
            border-radius: 0.375rem;
            overflow: hidden;
        }
        .copy-button {
            background: none;
            border: none;
            color: #a0a0a0;
            padding: 0.75rem;
            cursor: pointer;
        }
        
        /* Toast Notification */
        #toast-container {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            z-index: 1000;
            display: flex;
            flex-direction: column;
            gap: 10px;
            max-width: 90%;
        }
        .toast {
            background-color: #333;
            color: white;
            padding: 12px 24px;
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            opacity: 0;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            min-width: 250px;
            max-width: 100%;
        }
        .toast.show {
            opacity: 1;
            transform: translateY(0);
        }
        .toast.success {
            background-color: #22c55e;
        }
        .toast.error {
            background-color: #ef4444;
        }
        .toast.info {
            background-color: #3b82f6;
        }
        
        /* Responsive Adjustments */
        @media (max-width: 600px) {
            .channel-grid {
                grid-template-columns: repeat(2, 1fr);
            }
            .channel-logo {
                width: 48px;
                height: 48px;
            }
        }
    </style>
</head>
<body>
    <div class="container" id="rechargePage">
        <!-- Header -->
        <header class="header">
            <button class="icon-button back-button" onclick="history.back()">←</button>
            <h1 class="header-title">রিচার্জ</h1>
            <a href="<?php echo e(route('transactions')); ?>" class="header-link">রেকর্ড</a>
        </header>
        
        <!-- Balance Section -->
        <section class="balance-section">
            <p class="balance-label">আপনার বর্তমান ব্যালেন্স</p>
            <p class="balance-amount"><?php echo e(number_format(auth()->user()->balance, 2)); ?> ৳</p>
        </section>
        
        <!-- Alert Message -->
 <section class="alert-message">
    <?php if($lastDeposit): ?>
        <p class="alert-text">
            ব্যবহারকারী <?php echo e(substr(optional($lastDeposit->user)->phone ?? '0000000000', 0, 2)); ?>****<?php echo e(substr(optional($lastDeposit->user)->phone ?? '0000000000', -3)); ?> 
            ইতিমধ্যেই ৳<?php echo e(number_format($lastDeposit->amount)); ?> রিচার্জ করেছেন
        </p>
    <?php else: ?>
        <p class="alert-text">সর্বশেষ রিচার্জ তথ্য পাওয়া যায়নি</p>
    <?php endif; ?>
</section>

        
        <!-- Custom Recharge Input -->
        <section class="input-section">
            <div class="input-group">
                <label for="recharge-amount" class="input-label">রিচার্জের পরিমাণ (৳):</label>
                <input id="recharge-amount" type="number" placeholder="অন্যূনতম ৳100" class="input-field" min="100">
                <p class="input-error-message" id="recharge-amount-error"></p>
            </div>
        </section>
        
        <!-- Recharge Button -->
        <footer class="footer">
            <button id="rechargeButton" class="recharge-button">রিচার্জ করুন</button>
        </footer>
    </div>

    <!-- Payment Channel Modal -->
    <div class="modal-overlay" id="paymentChannelModal">
        <div class="modal-content">
            <h2 class="modal-title">পেমেন্ট মাধ্যম নির্বাচন করুন</h2>
            <div class="channel-grid" id="paymentMethodsContainer">
                <?php $__currentLoopData = $paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="channel-card" 
                     data-name="<?php echo e($method->name); ?>"
                     data-icon="<?php echo e(asset($method->icon)); ?>"
                     data-account="<?php echo e($method->account_number); ?>"
                     data-description="<?php echo e($method->description); ?>">
                    <img src="<?php echo e(asset($method->icon)); ?>" alt="<?php echo e($method->name); ?>" class="channel-logo">
                    <p class="channel-name"><?php echo e($method->name); ?></p>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <button class="recharge-button" id="confirmChannelButton" style="padding: 1rem;">নিশ্চিত করুন</button>
        </div>
    </div>

    <!-- Payment Details Page -->
    <div class="container payment-details-page" id="paymentDetailsPage">
        <header class="header">
            <button class="icon-button back-button" id="backToChannelSelection">←</button>
            <h1 class="header-title">পেমেন্ট সম্পন্ন করুন</h1>
        </header>
        
        <section class="payment-content">
            <p class="warning-text">পরিমাণ: <span id="displayAmount" style="font-weight: bold;">0</span> ৳</p>
            
            <div class="input-group">
                <label for="wallet-no" class="input-label">প্রাপকের নম্বর:</label>
                <div class="input-with-icon">
                    <input type="text" id="wallet-no" class="input-field" readonly>
                    <button class="copy-button" id="copyButton">কপি</button>
                </div>
                <p class="input-error-message" id="paymentMethodDescription"></p>
            </div>
            
            <div class="input-group">
                <label for="transaction-id" class="input-label">ট্রানজেকশন আইডি:</label>
                <input type="text" id="transaction-id" class="input-field" placeholder="আপনার ট্রানজেকশন আইডি লিখুন">
                <p class="input-error-message" id="transaction-id-error"></p>
            </div>
            
            <button class="recharge-button" id="submitPaymentButton" style="padding: 1rem;">জমা দিন</button>
            
            <p class="alert-text" style="margin-top: 1.5rem; font-size: 0.75rem;">
                সতর্কতা: ট্রানজেকশন আইডি সঠিকভাবে পূরণ করতে হবে, অন্যথায় রিচার্জ বাতিল হয়ে যাবে।
            </p>
        </section>
    </div>

    <!-- Toast Container -->
    <div id="toast-container"></div>

    <script>
    document.addEventListener('DOMContentLoaded', function() {
        // DOM Elements
        const rechargePage = document.getElementById('rechargePage');
        const paymentChannelModal = document.getElementById('paymentChannelModal');
        const paymentDetailsPage = document.getElementById('paymentDetailsPage');
        const rechargeButton = document.getElementById('rechargeButton');
        const confirmChannelButton = document.getElementById('confirmChannelButton');
        const submitPaymentButton = document.getElementById('submitPaymentButton');
        const rechargeAmountInput = document.getElementById('recharge-amount');
        const walletNoInput = document.getElementById('wallet-no');
        const transactionIdInput = document.getElementById('transaction-id');
        const displayAmountSpan = document.getElementById('displayAmount');
        const paymentMethodDescription = document.getElementById('paymentMethodDescription');
        const copyButton = document.getElementById('copyButton');
        const backToChannelSelection = document.getElementById('backToChannelSelection');
        const toastContainer = document.getElementById('toast-container');
        
        let selectedMethod = null;
        let rechargeAmount = 0;

        // Show Toast Notification
        function showToast(message, type = 'success') {
            const toast = document.createElement('div');
            toast.className = `toast ${type}`;
            toast.textContent = message;
            toastContainer.appendChild(toast);
            
            // Show toast
            setTimeout(() => {
                toast.classList.add('show');
            }, 10);
            
            // Hide after 5 seconds
            setTimeout(() => {
                toast.classList.remove('show');
                setTimeout(() => {
                    toastContainer.removeChild(toast);
                }, 300);
            }, 5000);
        }

        // Recharge Button Click
        rechargeButton.addEventListener('click', function() {
            const amount = parseFloat(rechargeAmountInput.value);
            
            if (isNaN(amount) || amount < 100) {
                showToast('অন্যূনতম ৳100 রিচার্জ করতে হবে', 'error');
                return;
            }
            
            rechargeAmount = amount;
            rechargePage.style.display = 'none';
            paymentChannelModal.style.display = 'flex';
        });

        // Payment Method Selection
        document.querySelectorAll('.channel-card').forEach(card => {
            card.addEventListener('click', function() {
                document.querySelectorAll('.channel-card').forEach(c => {
                    c.classList.remove('selected');
                });
                this.classList.add('selected');
                
                selectedMethod = {
                    name: this.dataset.name,
                    icon: this.dataset.icon,
                    account: this.dataset.account,
                    description: this.dataset.description
                };
            });
        });

        // Confirm Channel Button
        confirmChannelButton.addEventListener('click', function() {
            if (!selectedMethod) {
                showToast('অনুগ্রহ করে একটি পেমেন্ট মাধ্যম নির্বাচন করুন', 'error');
                return;
            }
            
            // Update payment details
            walletNoInput.value = selectedMethod.account;
            displayAmountSpan.textContent = rechargeAmount;
            paymentMethodDescription.textContent = selectedMethod.description;
            
            paymentChannelModal.style.display = 'none';
            paymentDetailsPage.style.display = 'block';
            
            // Show success message
            showToast(`${selectedMethod.name} মাধ্যম সফলভাবে নির্বাচন করা হয়েছে`);
        });

        // Back Button
        backToChannelSelection.addEventListener('click', function() {
            paymentDetailsPage.style.display = 'none';
            paymentChannelModal.style.display = 'flex';
        });

        // Copy Button
        copyButton.addEventListener('click', function() {
            walletNoInput.select();
            document.execCommand('copy');
            showToast('অ্যাকাউন্ট নম্বর কপি করা হয়েছে');
        });

        // Submit Payment
        submitPaymentButton.addEventListener('click', async function() {
            const transactionId = transactionIdInput.value.trim();
            
            if (!transactionId) {
                showToast('অনুগ্রহ করে ট্রানজেকশন আইডি লিখুন', 'error');
                return;
            }
            
            submitPaymentButton.disabled = true;
            submitPaymentButton.textContent = 'প্রসেসিং...';
            
            try {
                const formData = new FormData();
                formData.append('amount', rechargeAmount);
                formData.append('method', selectedMethod.name);
                formData.append('transaction_id', transactionId);
                formData.append('_token', '<?php echo e(csrf_token()); ?>');
                
                const response = await fetch('<?php echo e(route("deposit.store")); ?>', {
                    method: 'POST',
                    body: formData,
                    headers: {
                        'Accept': 'application/json',
                    }
                });
                
                const data = await response.json();
                
                if (data.success) {
                    showToast('রিচার্জ রিকোয়েস্ট সফলভাবে জমা হয়েছে!');
                    setTimeout(() => {
                        window.location.href = '<?php echo e(route("transactions")); ?>';
                    }, 2000);
                } else {
                    if (data.errors) {
                        const firstError = Object.values(data.errors)[0][0];
                        showToast(firstError, 'error');
                    } else {
                        showToast(data.message || 'রিচার্জ রিকোয়েস্ট জমা দিতে সমস্যা হয়েছে', 'error');
                    }
                }
            } catch (error) {
                console.error('Error:', error);
                showToast('নেটওয়ার্ক সমস্যা, পরে আবার চেষ্টা করুন', 'error');
            } finally {
                submitPaymentButton.disabled = false;
                submitPaymentButton.textContent = 'জমা দিন';
            }
        });
    });
    </script>
</body>
</html><?php /**PATH /home/ctrapple/public_html/resources/views/user/transactions/deposit.blade.php ENDPATH**/ ?>