
<?php $__env->startSection('main'); ?>
<?php
use App\Models\Setting;
?>
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Site Settings</h3>
                </div>
                <form action="<?php echo e(route('admin.settings.update')); ?>" method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>General Settings</h4>
                                
                                <div class="form-group">
                                    <label>Site Name</label>
                                    <input type="text" name="site_name" class="form-control" 
                                           value="<?php echo e(Setting::getValue('site_name')); ?>">
                                </div>

                                <div class="form-group">
                                    <label>Site Logo</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" name="site_logo" class="custom-file-input">
                                            <label class="custom-file-label">Choose file</label>
                                        </div>
                                    </div>
                                    <?php if(Setting::getValue('site_logo')): ?>
    <img src="<?php echo e(asset(Setting::getValue('site_logo'))); ?>" height="80" class="mt-2">
<?php endif; ?>
                                </div>

                                <div class="form-group">
                                    <label>Favicon</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" name="site_favicon" class="custom-file-input">
                                            <label class="custom-file-label">Choose file</label>
                                        </div>
                                    </div>
                                   <?php if(Setting::getValue('site_favicon')): ?>
    <img src="<?php echo e(asset(Setting::getValue('site_favicon'))); ?>" height="80" class="mt-2">
<?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h4>Contact Information</h4>
                                
                                <div class="form-group">
                                    <label>Contact Email</label>
                                    <input type="email" name="contact_email" class="form-control" 
                                           value="<?php echo e(Setting::getValue('contact_email')); ?>">
                                </div>

                                <div class="form-group">
                                    <label>Contact Phone</label>
                                    <input type="text" name="contact_phone" class="form-control" 
                                           value="<?php echo e(Setting::getValue('contact_phone')); ?>">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    // Display the name of the file on select
    document.querySelectorAll('.custom-file-input').forEach(function(input) {
        input.addEventListener('change', function(e) {
            var fileName = e.target.files[0].name;
            var nextSibling = e.target.nextElementSibling;
            nextSibling.innerText = fileName;
        });
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.admin_master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ctrapple/public_html/resources/views/admin/settings/index.blade.php ENDPATH**/ ?>