<div class="table-responsive mt-4">
    <?php if(session()->has('message')): ?>
    <div class="alert alert-<?php echo e(session('alert-type')); ?> alert-dismissible fade show" role="alert">
        <?php echo e(session('message')); ?>

        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    <?php endif; ?>

    <table class="table table-bordered table-hover">
        <thead class="bg-primary text-white">
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Transaction ID</th>
                <th>Status</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($transaction->id); ?></td>
               <td><?php echo e($transaction->user?->name ?? 'Unknown User'); ?></td>

                <td>
                    <span class="badge <?php echo e($transaction->type == 'deposit' ? 'bg-success' : 'bg-warning'); ?>">
                        <?php echo e(ucfirst($transaction->type)); ?>

                    </span>
                </td>
                <td>৳<?php echo e(number_format($transaction->amount, 2)); ?></td>
                <td><?php echo e(ucfirst($transaction->method)); ?></td>
                <td><?php echo e($transaction->transaction_id); ?></td>
                <td>
                    <form action="<?php echo e(route('admin.transactions.status', $transaction)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <select name="status" 
                                class="form-select form-select-sm status-select"
                                onchange="this.form.submit()"
                                style="min-width: 100px;">
                            <option value="pending" <?php echo e($transaction->status == 'pending' ? 'selected' : ''); ?>>Pending</option>
                            <option value="approved" <?php echo e($transaction->status == 'approved' ? 'selected' : ''); ?>>Approved</option>
                            <option value="rejected" <?php echo e($transaction->status == 'rejected' ? 'selected' : ''); ?>>Rejected</option>
                        </select>
                    </form>
                </td>
                <td><?php echo e($transaction->created_at->format('d M Y h:i A')); ?></td>
                <td>
                    <form action="<?php echo e(route('admin.transactions.destroy', $transaction)); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this transaction?')">
                            <i class="fas fa-trash"></i>
                        </button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($transactions->links()); ?>

</div>

<script>
// Simple confirmation before status change
document.querySelectorAll('.status-select').forEach(select => {
    select.addEventListener('change', function() {
        if (!confirm('Are you sure you want to change the status?')) {
            this.form.reset();
        }
    });
});
</script><?php /**PATH /home/ctrapple/public_html/resources/views/admin/transactions/_table.blade.php ENDPATH**/ ?>