<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>উত্তোলন ফর্ম</title>
    <style>
        body {
            margin: 0;
            font-family: "Inter", sans-serif;
            min-height: 100vh;
            background-color: #f5f5f5;
            color: #333;
        }
        .container {
            max-width: 800px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background-color: #1a1a1a;
            padding: 1rem;
            display: flex;
            align-items: center;
            justify-content: space-between;
            color: white;
            border-radius: 8px 8px 0 0;
        }
        .balance-section {
            background-color: #fff;
            padding: 1.5rem;
            text-align: center;
            margin-bottom: 1rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .form-section {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        .history-section {
            background-color: #fff;
            padding: 1.5rem;
            border-radius: 8px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .input-field {
            width: 100%;
            padding: 12px;
            border: 1px solid #ddd;
            border-radius: 6px;
            margin-top: 8px;
            font-size: 16px;
        }
        .method-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 12px;
            margin-top: 16px;
        }
        .method-card {
            background-color: #f9f9f9;
            padding: 12px;
            border-radius: 8px;
            cursor: pointer;
            text-align: center;
            border: 1px solid #ddd;
        }
        .method-card.selected {
            border: 2px solid #22c55e;
            background-color: #f0fff4;
        }
        .withdraw-button {
            width: 100%;
            background-color: #22c55e;
            color: white;
            padding: 14px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
            font-weight: bold;
            margin-top: 20px;
        }
        .text-danger {
            color: #ef4444;
            font-size: 14px;
            margin-top: 4px;
        }
        .text-muted {
            color: #666;
            font-size: 14px;
            margin-top: 4px;
        }
        .hidden {
            display: none;
        }
        .history-table {
            width: 100%;
            border-collapse: collapse;
        }
        .history-table th, .history-table td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        .history-table th {
            background-color: #f5f5f5;
        }
        .status-pending {
            color: #f59e0b;
        }
        .status-approved {
            color: #22c55e;
        }
        .status-rejected {
            color: #ef4444;
        }
            .toast {
            position: fixed;
            bottom: 20px;
            left: 50%;
            transform: translateX(-50%);
            background-color: #333;
            color: white;
            padding: 12px 24px;
            border-radius: 4px;
            z-index: 1000;
            display: none;
        }
        .toast.success {
            background-color: #22c55e;
        }
        .toast.error {
            background-color: #ef4444;
        }
        .alert {
            padding: 15px;
            margin-bottom: 20px;
            border-radius: 4px;
        }
        .alert-danger {
            background-color: #f8d7da;
            color: #721c24;
            border: 1px solid #f5c6cb;
        }
        .alert-success {
            background-color: #d4edda;
            color: #155724;
            border: 1px solid #c3e6cb;
        }
        .spinner-border {
            display: inline-block;
            width: 1rem;
            height: 1rem;
            vertical-align: text-bottom;
            border: 0.2em solid currentColor;
            border-right-color: transparent;
            border-radius: 50%;
            animation: spinner-border .75s linear infinite;
        }
        @keyframes spinner-border {
            to { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Header -->
    <header class="header">
        <a href="{{ route('dashboard') }}" style="color: white; text-decoration: none;">
            ← ফিরে যান
        </a>
        <h1 style="margin: 0; font-size: 1.5rem;">উত্তোলন</h1>
    </header>
    <!-- এরর মেসেজ ডিসপ্লে এরিয়া -->
    @if($errors->any())
    <div class="alert alert-danger">
        <ul style="margin: 0; padding-left: 1.5rem;">
            @foreach($errors->all() as $error)
            <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
    @endif

    @if(session('error'))
    <div class="alert alert-danger">
        {{ session('error') }}
    </div>
    @endif

    @if(session('success'))
    <div class="alert alert-success">
        {{ session('success') }}
    </div>
    @endif
    <!-- Balance Section -->
    <section class="balance-section">
        <p style="margin: 0; font-size: 1rem; color: #666;">আপনার বর্তমান ব্যালেন্স</p>
        <p style="margin: 0; font-size: 2rem; font-weight: bold; color: #22c55e;">{{ number_format(auth()->user()->balance, 2) }} ৳</p>
    </section>
    
    <!-- Withdrawal Form Section -->
    <section class="form-section">
        <form method="POST" action="{{ route('withdraw.store') }}" id="withdrawForm">
            @csrf
            
            <!-- Amount Input -->
            <div style="margin-bottom: 20px;">
                <label for="amount" style="font-weight: bold; display: block;">
                    উত্তোলনের পরিমাণ (৳):
                </label>
                <input
                    id="amount"
                    name="amount"
                    type="number"
                    step="0.01"
                    min="500"
                    placeholder="উত্তোলনের পরিমাণ লিখুন"
                    class="input-field"
                    required
                    value="{{ old('amount') }}"
                />
                @error('amount')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
                <small class="text-muted">ন্যূনতম উত্তোলন পরিমাণ: ৫০০ ৳</small>
            </div>
            
            <!-- Payment Method Selection -->
            <div style="margin-bottom: 20px;">
                <h2 style="margin: 0 0 10px 0; font-size: 1.2rem;">উত্তোলনের পদ্ধতি নির্বাচন করুন</h2>
                <div class="method-grid">
                    @foreach($methods as $method)
                    <div class="method-card" onclick="selectMethod('{{ $method->id }}')">
                        <input 
                            type="radio" 
                            name="payment_method_id" 
                            value="{{ $method->id }}" 
                            id="method_{{ $method->id }}"
                            class="method-radio" 
                            required
                            {{ old('payment_method_id') == $method->id ? 'checked' : '' }}
                            style="display: none;"
                        >
                        <img src="{{ asset($method->icon) }}" alt="{{ $method->name }}" style="width: 40px; height: 40px;">
                        <p style="margin: 8px 0 0 0; font-weight: 500;">{{ $method->name }}</p>
                    </div>
                    @endforeach
                </div>
                @error('payment_method_id')
                    <small class="text-danger">{{ $message }}</small>
                @enderror
            </div>
            
            <!-- Wallet Number Input -->
            <div id="method-details-container">
                @foreach($methods as $method)
                <div id="details_{{ $method->id }}" class="method-details {{ old('payment_method_id') == $method->id ? '' : 'hidden' }}">
                    <div style="margin-bottom: 20px;">
                        <label for="wallet_number_{{ $method->id }}" style="font-weight: bold; display: block;">
                            {{ $method->name }} নম্বর:
                        </label>
                        
                        @if(isset($wallet_info[$method->name]) && !empty($wallet_info[$method->name]))
                        <!-- Saved wallet number -->
                        <input 
                            type="text" 
                            class="input-field" 
                            value="{{ $wallet_info[$method->name] }}" 
                            readonly
                            style="background-color: #f5f5f5;"
                        >
                        <input type="hidden" name="wallet_info[{{ $method->name }}]" value="{{ $wallet_info[$method->name] }}">
                        <small class="text-muted">এই তথ্য পূর্বেই সংরক্ষণ করা হয়েছে</small>
                        @else
                        <!-- New wallet number input -->
                       <input 
    type="text" 
    id="wallet_number_{{ $method->id }}" 
    name="wallet_info[{{ $method->name }}]"
    class="input-field" 
    placeholder="01XXXXXXXXX" 
    maxlength="11"
    pattern="01[3-9]{1}[0-9]{8}" 
    value="{{ old('wallet_info.'.$method->name) }}"
    oninput="validateMobileNumber(this)"
    required
>
<small class="text-muted">এই তথ্য একবার সংরক্ষণের পর পরিবর্তন করা যাবে না</small>

                        
                        
                        @endif
                        @error('wallet_info.'.$method->name)
                            <small class="text-danger">{{ $message }}</small>
                        @enderror
                    </div>
                </div>
                @endforeach
            </div>
            
            <!-- Submit Button -->
         <button type="submit" class="withdraw-button" id="submitBtn" @php
    $now = now();
    $day = $now->dayOfWeek; // 0 (Sunday) to 6 (Saturday)
    $startTime = now()->setTime(10, 0); // সকাল ১০টা
    $endTime = now()->setTime(18, 0); // বিকাল ৬টা
    
    // শুক্রবার (5) এবং শনিবার (6) ডিজেবল করুন
    if ($day === 5 || $day === 6) {
        echo 'disabled';
    } 
    // অন্য দিনগুলোর জন্য সময় চেক করুন
    else if ($now < $startTime || $now > $endTime) {
        echo 'disabled';
    }
@endphp>
    @php
        $now = now();
        $day = $now->dayOfWeek;
        $startTime = now()->setTime(10, 0);
        $endTime = now()->setTime(18, 0);
        
        if ($day === 5 || $day === 6) {
            echo 'শুক্রবার ও শনিবার উত্তোলন বন্ধ';
        } else if ($now >= $startTime && $now <= $endTime) {
            echo 'এখনই উত্তোলন করুন';
        } else {
            echo 'উত্তোলনের সময়: সকাল ১০টা থেকে বিকাল ৬টা';
        }
    @endphp
</button>
        </form>
    </section>
    
    <!-- Withdrawal History Section -->
    <section class="history-section">
        <h2 style="margin: 0 0 20px 0; font-size: 1.3rem;">আপনার উত্তোলনের ইতিহাস</h2>
        
        @if($withdrawals->count() > 0)
        <table class="history-table">
            <thead>
                <tr>
                    <th>তারিখ</th>
                    <th>পদ্ধতি</th>
                    <th>পরিমাণ</th>
                    <th>স্ট্যাটাস</th>
                    
                </tr>
            </thead>
            <tbody>
                @foreach($withdrawals as $withdrawal)
                <tr>
                    <td>{{ $withdrawal->created_at->format('d M Y h:i A') }}</td>
                    <td>{{ $withdrawal->paymentMethod->name }}</td>
                    <td>{{ number_format($withdrawal->amount, 2) }} ৳</td>
                    <td>
                        @if($withdrawal->status == 'pending')
                            <span class="status-pending">মুলতুবি</span>
                        @elseif($withdrawal->status == 'approved')
                            <span class="status-approved">অনুমোদিত</span>
                        @else
                            <span class="status-rejected">প্রত্যাখ্যাত</span>
                        @endif
                    </td>
                    
                </tr>
                @endforeach
            </tbody>
        </table>
        
        <div style="margin-top: 20px;">
            {{ $withdrawals->links() }}
        </div>
        @else
        <p style="text-align: center; color: #666;">আপনার কোনো উত্তোলনের ইতিহাস পাওয়া যায়নি</p>
        @endif
    </section>
</div>

<script>


// বাটন এলিমেন্ট সিলেক্ট করুন
const submitBtn = document.getElementById('submitBtn');

function updateButtonText() {
    const now = new Date();
    const day = now.getDay(); // 0 = Sunday, 1 = Monday, ..., 6 = Saturday
    const hours = now.getHours();
    
    // শুক্রবার (5) এবং শনিবার (6) ডিজেবল করুন
    if (day === 5 || day === 6) {
        submitBtn.innerHTML = 'শুক্রবার ও শনিবার উত্তোলন বন্ধ';
        submitBtn.disabled = true;
        return;
    }
    
    // রবি থেকে বৃহস্পতিবার (0-4) সকাল ১০টা (10) থেকে বিকাল ৬টা (18) পর্যন্ত
    if (hours >= 10 && hours < 18) {
        submitBtn.innerHTML = 'এখনই উত্তোলন করুন';
        submitBtn.disabled = false;
    } else {
        submitBtn.innerHTML = 'উত্তোলনের সময়: সকাল ১০টা থেকে বিকাল ৬টা';
        submitBtn.disabled = true;
    }
}

// পেইজ লোড হলে ফাংশন কল করুন
updateButtonText();

// প্রতি মিনিটে চেক করুন (ঐচ্ছিক)
setInterval(updateButtonText, 60000);


// Select payment method and show details
function selectMethod(methodId) {
    // Remove required from all wallet inputs first
    document.querySelectorAll('[name^="wallet_info["]').forEach(input => {
        input.removeAttribute('required');
    });
    
    // Select the radio button
    document.getElementById('method_' + methodId).checked = true;
    
    // Hide all method details
    document.querySelectorAll('.method-details').forEach(el => {
        el.classList.add('hidden');
    });
    
    // Show selected method details
    const detailsEl = document.getElementById('details_' + methodId);
    if (detailsEl) {
        detailsEl.classList.remove('hidden');
        
        // Add required to the visible input if it exists and not readonly
        const walletInput = detailsEl.querySelector('input[type="text"]:not([readonly])');
        if (walletInput) {
            walletInput.setAttribute('required', 'required');
        }
    }
    
    // Update selected class
    document.querySelectorAll('.method-card').forEach(el => {
        el.classList.remove('selected');
    });
    event.currentTarget.classList.add('selected');
}

// Mobile number validation
function validateMobileNumber(input) {
    const regex = /^01[3-9]\d{0,9}$/; // সর্বোচ্চ 11 ডিজিট
    if (!regex.test(input.value)) {
        input.value = input.value.replace(/[^0-9]/g, ''); // শুধু সংখ্যা রাখতে দেবে
    }
}


// Initialize selected method on page load
document.addEventListener('DOMContentLoaded', function() {
    const selectedMethod = document.querySelector('input[name="payment_method_id"]:checked');
    if (selectedMethod) {
        selectMethod(selectedMethod.value);
    }
    
    // Form submission handling
    const form = document.getElementById('withdrawForm');
    if (form) {
        form.addEventListener('submit', function(e) {
            const submitBtn = document.getElementById('submitBtn');
            submitBtn.disabled = true;
            submitBtn.innerHTML = 'প্রসেসিং...';
            
            // Basic validation
            const amount = parseFloat(form.amount.value);
            const method = form.querySelector('input[name="payment_method_id"]:checked');
            const walletInput = method ? document.getElementById('wallet_number_' + method.value) : null;
            
            if (isNaN(amount) || amount <= 0) {
                alert('অনুগ্রহ করে একটি বৈধ উত্তোলনের পরিমাণ লিখুন।');
                e.preventDefault();
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'এখনই উত্তোলন করুন';
                return;
            }
            
            if (amount < 500) {
                alert('ন্যূনতম উত্তোলন পরিমাণ ৫০০ ৳');
                e.preventDefault();
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'এখনই উত্তোলন করুন';
                return;
            }
            
            if (!method) {
                alert('অনুগ্রহ করে একটি উত্তোলনের পদ্ধতি নির্বাচন করুন।');
                e.preventDefault();
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'এখনই উত্তোলন করুন';
                return;
            }
            
            if (walletInput && !walletInput.readOnly && !walletInput.value.trim()) {
                alert('অনুগ্রহ করে আপনার ওয়ালেট নম্বর প্রদান করুন।');
                e.preventDefault();
                submitBtn.disabled = false;
                submitBtn.innerHTML = 'এখনই উত্তোলন করুন';
                return;
            }
        });
    }
});
</script>
</body>
</html>