<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>বাংলাদেশী মুদ্রা পাতা</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <!-- Lucide Icons (for icons like ArrowRight, Copy, Diamond, etc.) -->
    <script src="https://unpkg.com/lucide@latest"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        /* Basic Reset and Font Import */
        body {
            margin: 0;
            font-family: "Inter", sans-serif;
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            color: white !important;
        }
        a,span,i{
            cursor: pointer;
        }
        /* Utility Classes (mimicking some Tailwind behavior) */
        .min-h-screen {
            min-height: 100vh;
        }
        .bg-white {
            background-color: #000;
        }
        .flex {
            display: flex;
        }
        .flex-col {
            flex-direction: column;
        }
        .items-center {
            align-items: center;
        }
        .justify-between {
            justify-content: space-between;
        }
        .justify-center {
            justify-content: center;
        }
        .justify-around {
            justify-content: space-around;
        }
        .p-4 {
            padding: 1rem; /* 16px */
        }
        .px-4 {
            padding-left: 1rem;
            padding-right: 1rem;
        }
        .pb-20 {
            padding-bottom: 5rem; /* 80px */
        }
        a{
            text-decoration: none;
        }
        .mt-2 {
            margin-top: 0.5rem; /* 8px */
        }
        .m-4 {
            margin: 1rem; /* 16px */
        }
        .mx-4 {
            margin-left: 1rem;
            margin-right: 1rem;
        }
        .mb-4 {
            margin-bottom: 1rem;
        }
        .space-x-3 > *:not(:first-child) {
            margin-left: 0.75rem; /* 12px */
        }
        .space-y-1 > *:not(:first-child) {
            margin-top: 0.25rem; /* 4px */
        }
        .text-lg {
            font-size: 1.125rem; /* 18px */
            line-height: 1.75rem; /* 28px */
        }
        .text-sm {
            font-size: 0.875rem; /* 14px */
            line-height: 1.25rem; /* 20px */
        }
        .text-xs {
            font-size: 0.75rem; /* 12px */
            line-height: 1rem; /* 16px */
        }
        .text-5xl {
            font-size: 3rem; /* 48px */
            line-height: 1;
        }
        .font-bold {
            font-weight: 700;
        }
        .font-semibold {
            font-weight: 600;
        }
        .text-white {
            color: #000000;
        }
        .text-gray-800 {
            color: #ffffff;
        }
        .text-gray-700 {
            color: #ffffff;
        }
        .text-gray-600 {
            color: #ffffff;
        }
        .text-gray-500 {
            color: #ffffff;
        }
        .text-gray-200 {
            color: #e5e7eb;
        }
        .text-pink-500 {
            color: #ec4899;
        }
        .text-yellow-400 {
            color: #facc15;
        }
        .text-center {
            text-align: center;
        }
        .text-right {
            text-align: right;
        }
        .rounded-full {
            border-radius: 9999px;
        }
        .rounded-lg {
            border-radius: 0.5rem; /* 8px */
        }
        .shadow-sm {
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
        }
        .shadow-md {
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .shadow-lg {
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .relative {
            position: relative;
        }
        .absolute {
            position: absolute;
        }
        .top-0 {
            top: 0;
        }
        .right-0 {
            right: 0;
        }
        .w-24 {
            width: 6rem; /* 96px */
        }
        .h-24 {
            height: 6rem; /* 96px */
        }
        .transform {
            transform: translate(var(--tw-translate-x), var(--tw-translate-y)) rotate(var(--tw-rotate)) skewX(var(--tw-skew-x))
                skewY(var(--tw-skew-y)) scaleX(var(--tw-scale-x)) scaleY(var(--tw-scale-y));
        }
        .translate-x-1\/2 {
            --tw-translate-x: 50%;
        }
        .-translate-y-1\/2 {
            --tw-translate-y: -50%;
        }
        .opacity-70 {
            opacity: 0.7;
        }
        .z-10 {
            z-index: 10;
        }
        .overflow-hidden {
            overflow: hidden;
        }
        .grid {
            display: grid;
        }
        .grid-cols-2 {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }
        .grid-cols-4 {
            grid-template-columns: repeat(4, minmax(0, 1fr));
        }
        .gap-4 {
            gap: 1rem; /* 16px */
        }
        .border {
            border-width: 1px;
        }
        .border-white {
            border-color: #ffffff;
        }
        .border-gray-200 {
            border-color: #e5e7eb;
        }
        .border-t {
            border-top-width: 1px;
        }
        .fixed {
            position: fixed;
        }
        .bottom-0 {
            bottom: 0;
        }
        .left-0 {
            left: 0;
        }
        .right-0 {
            right: 0;
        }
        .h-16 {
            height: 4rem; /* 64px */
        }
        .w-6 {
            width: 1.5rem; /* 24px */
        }
        .h-6 {
            height: 1.5rem; /* 24px */
        }
        .w-4 {
            width: 1rem; /* 16px */
        }
        .h-4 {
            height: 1rem; /* 16px */
        }
        .w-3 {
            width: 0.75rem; /* 12px */
        }
        .h-3 {
            height: 0.75rem; /* 12px */
        }
        .ml-1 {
            margin-left: 0.25rem; /* 4px */
        }
        .cursor-pointer {
            cursor: pointer;
        }
        /* Specific Component Styles */
        /* Header */
        .header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1rem;
            background-color: #000;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            position: relative;
            overflow: hidden;
        }
        .header-bg-circle {
            position: absolute;
            top: 0;
            right: 0;
            width: 6rem;
            height: 6rem;
            border-radius: 9999px;
            transform: translateX(50%) translateY(-50%);
            opacity: 0.7;
        }
        .header-content {
            display: flex;
            align-items: center;
            gap: 0.75rem; /* space-x-3 */
            z-index: 10;
        }
        .avatar-container {
            width: 3rem; /* w-12 */
            height: 3rem; /* h-12 */
            background-color: #ec4899; /* pink-500 */
            color: #ffffff;
            font-weight: 700;
            font-size: 1.25rem; /* text-xl */
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 9999px;
        }
        .user-info {
            display: flex;
            flex-direction: column;
        }
        .username {
            display: flex;
            align-items: center;
            font-size: 1.125rem; /* text-lg */
            font-weight: 600;
            color: #ffffff; /* gray-800 */
        }
        .version {
            color: #ffffff; /* gray-500 */
            font-size: 0.875rem; /* text-sm */
            margin-left: 0.25rem; /* ml-1 */
        }
        .uid {
            display: flex;
            align-items: center;
            font-size: 0.875rem; /* text-sm */
            color: #ffffff; /* gray-600 */
        }
        .icon-copy {
            width: 0.75rem; /* w-3 */
            height: 0.75rem; /* h-3 */
            margin-left: 0.25rem; /* ml-1 */
            cursor: pointer;
        }
        .header-button {
            background: none;
            border: none;
            padding: 0.5rem; /* size-icon equivalent */
            color: #4b5563; /* text-gray-600 */
            z-index: 10;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .icon-arrow-right {
            width: 1.5rem; /* w-6 */
            height: 1.5rem; /* h-6 */
        }
        /* VIP Section */
        .vip-section {
            background-color: #1a202c; /* Custom dark background */
            color: #ffffff;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 1rem;
            margin-top: 0.5rem;
            margin-left: 1rem;
            margin-right: 1rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .vip-info {
            display: flex;
            align-items: center;
            gap: 0.75rem; /* space-x-3 */
        }
        .icon-diamond {
            width: 1.5rem;
            height: 1.5rem;
            color: #facc15; /* yellow-400 */
        }
        .vip-text {
            font-size: 1.125rem;
            font-weight: 600;
        }
        .vip-check-button {
            background: none;
            color: #facc15; /* yellow-400 */
            font-size: 0.875rem;
            padding: 0.25rem 0.75rem; /* px-3 py-1 */
            border-radius: 9999px;
            border: 1px solid #facc15; /* border border-yellow-400 */
            cursor: pointer;
        }
        /* Account Balance Card */
        .account-card {
            background-color: #008080; /* Custom teal background */
            color: #ffffff;
            padding: 1rem;
            margin: 1rem;
            border-radius: 0.5rem;
            box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
        }
        .account-card-header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 1rem;
        }
        .account-card-title {
            font-size: 1.125rem;
            font-weight: 600;
            margin: 0; /* Remove default h2 margin */
        }
        a.Support {
    color: white;
    background: #4da94d;
    padding: 20px 10px;
    border-radius: 37px;
}
        .account-details-button {
            background: none;
            color: #ffffff;
            font-size: 0.875rem;
            padding: 0.25rem 0.75rem;
            border-radius: 9999px;
            border: 1px solid #ffffff;
            cursor: pointer;
        }
        .log-out i {color: #fff;}
        .balance-amount {
            font-size: 3rem;
            font-weight: 700;
            margin-bottom: 1rem;
        }
        .balance-details-grid {
            display: grid;
            grid-template-columns: repeat(2, minmax(0, 1fr));
            gap: 1rem;
            font-size: 0.875rem;
        }
        .detail-label {
            color: #e5e7eb; /* gray-200 */
            margin-bottom: 0.25rem;
        }
        .detail-value {
            font-size: 1.125rem;
            font-weight: 600;
        }
        /* Withdrawal Account Section */
        .withdrawal-section {
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding-left: 1rem;
            padding-right: 1rem;
            margin-top: 1rem;
            margin-bottom: 1rem;
        }
        .withdrawal-title {
            font-size: 1.125rem;
            font-weight: 600;
            color: #ffffff; /* gray-800 */
            margin: 0; /* Remove default h3 margin */
        }
        .icon-arrow-right-small {
            width: 1rem;
            height: 1rem;
            color: #ffffff; /* gray-600 */
        }
        /* Action Grid */
        .action-grid {
            display: grid;
            grid-template-columns: repeat(4, minmax(0, 1fr));
            gap: 1rem;
            padding-left: 1rem;
            padding-right: 1rem;
            padding-bottom: 5rem; /* pb-20 */
        }
        .action-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
            text-align: center;
            gap: 0.25rem; /* space-y-1 */
        }
        .action-icon-bg {
            background-color: #f3f4f6; /* gray-100 */
            border-radius: 9999px;
            padding: 0.75rem; /* p-3 */
            display: flex; /* To center the icon */
            align-items: center;
            justify-content: center;
        }
        .action-icon {
            width: 1.5rem;
            height: 1.5rem;
            color: #008080; /* Custom teal color */
        }
        .action-label {
            font-size: 0.75rem;
            color: #ffffff; /* gray-700 */
        }
        .action-item-placeholder {
            /* For consistent grid layout if 8th item is not present */
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem;
        }
        /* Bottom Navigation */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: #ffffff;
            border-top: 1px solid #e5e7eb; /* border-t border-gray-200 */
            display: flex;
            justify-content: space-around;
            align-items: center;
            height: 4rem; /* h-16 */
            box-shadow: 0 10px 15px -3px rgba(0, 0, 0, 0.1), 0 4px 6px -2px rgba(0, 0, 0, 0.05);
        }
        .nav-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 0.25rem; /* space-y-1 */
            color: #ffffff; /* gray-500 */
        }
        .nav-item.active {
            color: #008080; /* Custom teal color */
        }
        .nav-icon {
            width: 1.5rem;
            height: 1.5rem;
        }
        .nav-label {
            font-size: 0.75rem;
        }
        /* Footer Menu */
        .footer-menu {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background: #1a1a1a;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            box-shadow: 0 -2px 10px rgba(0, 0, 0, 0.3);
            z-index: 1000;
        }
        .footer-content {
            display: flex;
            justify-content: space-around;
            align-items: center;
            padding: 15px 20px;
            max-width: 1200px;
            margin: 0 auto;
        }
        .footer-item {
            display: flex;
            flex-direction: column;
            align-items: center;
            text-decoration: none;
            color: #cccccc;
            transition: all 0.3s ease;
            padding: 8px;
            border-radius: 10px;
        }
        .footer-item:hover,
        .footer-item.active {
            color: #ffffff;
            background: rgba(255, 255, 255, 0.1);
        }
        .footer-icon {
            font-size: 20px;
            margin-bottom: 5px;
        }
        .footer-text {
            font-size: 12px;
            font-weight: 500;
        }
        /* হেডার বেসিক স্ট্রাকচার */


/* ভেতরের কনটেন্টে ফ্লেক্স */
.header-content {
  display: flex;
  align-items: center;
  gap: 15px;
  flex: 1;
  min-width: 250px;
}

/* অবতার ফালব্যাক */
.avatar-container {
  width: 50px;
  height: 50px;
  background: #004d4d;
  border-radius: 50%;
  display: flex;
  align-items: center;
  justify-content: center;
  font-weight: 700;
  font-size: 18px;
  color: white;
}

/* ইউজার ইনফো */
.user-info {
  display: flex;
  flex-direction: column;
  justify-content: center;
}

/* ইউজারনেম */
.username {
  font-weight: 700;
  font-size: 18px;
  display: flex;
  align-items: center;
}

/* রেফারেল লিঙ্কের ইনপুট ও বাটন */
input#referralLink {
  max-width: 100%;
  box-sizing: border-box;
}

/* Support টিম লিঙ্ক */
.Support a {
  color: white;
  text-decoration: none;
  font-weight: 600;
  background: #006666;
  padding: 6px 12px;
  border-radius: 6px;
  transition: background-color 0.3s;
}
.Support a:hover {
  background: #004d4d;
}

/* লগআউট বাটন */
.log-out button {
  color: white;
  font-size: 20px;
}

/* Responsive মোবাইল ডিজাইন */
@media (max-width: 768px) {
  .header {
    flex-direction: column;
    align-items: center;
    text-align: center;
  }

  .header-content {
    flex-direction: column;
    gap: 10px;
    width: 100%;
  }

  .user-info {
    align-items: center;
  }

  input#referralLink {
    width: 100%;
  }

  .Support, .log-out {
    margin-top: 10px;
  }
}

 #username-edit-form {
            display: inline-block;
            margin-left: 5px;
        }

        #username-input {
            padding: 3px 8px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 1.125rem;
            width: 150px;
            background: #f3f4f6;
            color: #000;
        }

        #edit-username {
            color: #008080;
            transition: color 0.3s;
            cursor: pointer;
        }

        #edit-username:hover {
            color: #006666;
        }

        #save-username, #cancel-edit {
            padding: 3px 8px;
            border-radius: 4px;
            cursor: pointer;
            font-size: 0.875rem;
        }

        #save-username {
            background: #008080;
            color: white;
            border: none;
        }

        #cancel-edit {
            background: #ccc;
            color: #000;
            border: none;
            margin-left: 5px;
        }

    </style>
</head>
<body class="min-h-screen bg-white flex flex-col font-inter">
    <!-- Header -->
    <header class="header">
        <div class="header-bg-circle"></div>
        <div class="header-content">
            <div class="avatar-container">
                <div class="avatar-fallback" id="avatar-fallback">{{ strtoupper(substr($user->name, 0, 2)) }}</div>
            </div>
            <div class="user-info">
                <div class="username">
                    <span id="username-display">{{ $user->name ?? 'Mr. User' }}</span>
                    <i class="fas fa-edit ml-2" id="edit-username" style="font-size: 14px;"></i>
                    @if($user->is_vip)
                        <span class="version vip-badge">
                            <i class="fas fa-crown"></i> VIP
                        </span>
                    @endif
                </div>

                <!-- Hidden edit form -->
                <div id="username-edit-form" style="display: none;">
                    <input type="text" id="username-input" value="{{ $user->name }}">
                    <button id="save-username">Save</button>
                    <button id="cancel-edit">Cancel</button>
                </div>

                <style>
                .vip-badge {
                    margin-left: 5px;
                    font-weight: bold;
                    position: relative;
                    display: inline-block;
                    font-size: 16px;
                    text-transform: uppercase;
                    background: linear-gradient(90deg, #FFD700, #FFC107, #FFD700);
                    -webkit-background-clip: text;
                    -webkit-text-fill-color: transparent;
                    animation: shimmer 3s linear infinite;
                }

                @keyframes shimmer {
                    0% { background-position: -200% 0; }
                    100% { background-position: 200% 0; }
                }

                .vip-badge { background-size: 200% auto; }
                </style>
                
                <!-- Rest of your existing content -->
                <div class="mt-2">
                    <p style="color: white; font-size: 14px; margin-bottom: 5px;">
                        রেফারেল কোড: <strong>{{ $user->referral_code }}</strong>
                        <i data-lucide="copy" class="icon-copy" onclick="copyReferralCode()"></i>
                    </p>
                    <div style="display: flex; align-items: center;">
                        <input type="text" 
                               style="background: #f3f4f6; color: #000; border: none; padding: 5px; border-radius: 4px; font-size: 12px; width: 150px;"
                               id="referralLink" 
                               value="{{ route('register', ['ref' => $user->referral_code]) }}" 
                               readonly>
                        <button style="background: #008080; color: white; border: none; padding: 5px 10px; border-radius: 4px; margin-left: 5px; font-size: 12px;"
                                onclick="copyReferralLink()">
                            কপি
                        </button>
                    </div>
                    <p style="color: white; font-size: 12px; margin-top: 5px;">
                        রেফার্ড ইউজার: {{ $user->referrals()->count() }} জন
                    </p>
                </div>
            </div>
        </div>
        
        @if($supportSetting && $supportSetting->telegram_link)
        <div class="Support">
            <a href="{{ $supportSetting->telegram_link }}" class="Support">
                Support team
            </a>
        </div>
        @endif
        
        <div class="log-out">
            <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: inline;">
                @csrf
                <button type="submit" style="background: none; border: none; cursor: pointer;">
                    <i class="fa-solid fa-right-from-bracket"></i>
                </button>
            </form>
        </div>
    </header>

    <!-- Account Balance Card -->
  <div class="account-card">
        <div class="account-card-header">
            <h2 class="account-card-title">অ্যাকাউন্ট ব্যালেন্স (৳)</h2>
            <button class="account-details-button">
                অ্যাকাউন্ট বিবরণ
            </button>
        </div>
        <div class="balance-amount"> {{ $user->balance }}</div>
        <div class="balance-details-grid">
            <div>
                <p class="detail-label">মোট বেতন</p>
                <p class="detail-value">{{ number_format($user->total_earnings ?? 0, 2) }}</p>
            </div>
            <div class="text-right">
                <p class="detail-label">মোট উত্তোলন</p>
                <p class="detail-value">{{ number_format($totalWithdrawals, 2) }}</p>
            </div>
             <div>
                <p class="detail-label">মোট আয়</p>
                <p class="detail-value">{{ number_format($user->total_income ?? 0, 2) }}</p>
            </div>
            <div class="text-right">
                <p class="detail-label">টিম সাইজ</p>
                <p class="detail-value">{{ $user->team_size ?? 0 }}</p>
            </div>
        </div>
    </div>
 
 
    <!-- Footer Menu -->
    @include('layouts.footer')

    <script>
       document.addEventListener('DOMContentLoaded', function() {
        // Initialize icons
        lucide.createIcons();

        // Copy Referral Code
        function copyReferralCode() {
            const referralCode = "{{ $user->referral_code }}";
            navigator.clipboard.writeText(referralCode)
                .then(() => {
                    alert(`রেফারেল কোড ${referralCode} কপি করা হয়েছে!`);
                })
                .catch((err) => {
                    console.error("রেফারেল কোড কপি করতে ব্যর্থ: ", err);
                    alert("রেফারেল কোড কপি করতে সমস্যা হয়েছে। ম্যানুয়ালি কপি করুন।");
                });
        }

        // Copy Referral Link
        function copyReferralLink() {
            const referralLink = document.getElementById('referralLink').value;
            navigator.clipboard.writeText(referralLink)
                .then(() => {
                    alert(`রেফারেল লিঙ্ক কপি করা হয়েছে!\n\n${referralLink}`);
                })
                .catch((err) => {
                    console.error("রেফারেল লিঙ্ক কপি করতে ব্যর্থ: ", err);
                    alert("রেফারেল লিঙ্ক কপি করতে সমস্যা হয়েছে। ম্যানুয়ালি কপি করুন।");
                });
        }

        // Add event listeners
        document.querySelector('.icon-copy').addEventListener('click', copyReferralCode);
        document.querySelector('[onclick="copyReferralLink()"]').addEventListener('click', copyReferralLink);
            
            

            // Username edit functionality
            const editBtn = document.getElementById('edit-username');
            const displaySpan = document.getElementById('username-display');
            const editForm = document.getElementById('username-edit-form');
            const usernameInput = document.getElementById('username-input');
            const saveBtn = document.getElementById('save-username');
            const cancelBtn = document.getElementById('cancel-edit');
            const avatarFallback = document.getElementById('avatar-fallback');
            
            editBtn.addEventListener('click', function() {
                displaySpan.style.display = 'none';
                editBtn.style.display = 'none';
                editForm.style.display = 'block';
                usernameInput.focus();
            });
            
            cancelBtn.addEventListener('click', function() {
                displaySpan.style.display = 'inline';
                editBtn.style.display = 'inline';
                editForm.style.display = 'none';
                usernameInput.value = displaySpan.textContent;
            });
            
            saveBtn.addEventListener('click', updateUsername);
            
            usernameInput.addEventListener('keypress', function(e) {
                if(e.key === 'Enter') {
                    updateUsername();
                }
            });
            
            function updateUsername() {
                const newName = usernameInput.value.trim();
                
                if(newName === '') {
                    alert('Username cannot be empty!');
                    return;
                }
                
                // Show loading state
                saveBtn.disabled = true;
                saveBtn.textContent = 'Saving...';
                
                fetch('{{ route("user.update-name") }}', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '{{ csrf_token() }}',
                        'Accept': 'application/json'
                    },
                    body: JSON.stringify({
                        name: newName
                    })
                })
                .then(response => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok');
                    }
                    return response.json();
                })
                .then(data => {
                    if(data.success) {
                        displaySpan.textContent = newName;
                        avatarFallback.textContent = newName.substring(0, 2).toUpperCase();
                        displaySpan.style.display = 'inline';
                        editBtn.style.display = 'inline';
                        editForm.style.display = 'none';
                        
                        // Show success message
                        showToast('Username updated successfully!', 'success');
                    } else {
                        throw new Error(data.message || 'Failed to update username');
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    showToast('Error updating username: ' + error.message, 'error');
                    // Restore original value on error
                    usernameInput.value = displaySpan.textContent;
                })
                .finally(() => {
                    saveBtn.disabled = false;
                    saveBtn.textContent = 'Save';
                });
            }

            // Toast notification function
            function showToast(message, type = 'info') {
                const toast = document.createElement('div');
                toast.style.position = 'fixed';
                toast.style.bottom = '20px';
                toast.style.right = '20px';
                toast.style.padding = '10px 20px';
                toast.style.borderRadius = '4px';
                toast.style.color = 'white';
                toast.style.zIndex = '1000';
                toast.style.transition = 'all 0.3s ease';
                
                if (type === 'success') {
                    toast.style.backgroundColor = '#4CAF50';
                } else if (type === 'error') {
                    toast.style.backgroundColor = '#F44336';
                } else {
                    toast.style.backgroundColor = '#2196F3';
                }
                
                toast.textContent = message;
                document.body.appendChild(toast);
                
                setTimeout(() => {
                    toast.style.opacity = '0';
                    setTimeout(() => {
                        document.body.removeChild(toast);
                    }, 300);
                }, 3000);
            }

            // Initialize icons
            lucide.createIcons();
        });
    </script>
</body>
</html>
