<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sign Up - Join Us</title>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
        <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        a{
    text-decoration: none;
}
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #000000;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            line-height: 1.6;
            overflow-x: hidden;
        }

        .signup-container {
            background: #ffffff;
            border-radius: 24px;
            box-shadow: 0 25px 50px rgba(255, 255, 255, 0.1);
            width: 100%;
            max-width: 440px;
            overflow: hidden;
            position: relative;
            opacity: 0;
            transform: translateY(50px);
        }

        .header {
            background: linear-gradient(135deg, #1f1f1f 0%, #000000 100%);
            padding: 30px 30px 25px;
            position: relative;
            color: white;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            color: #ffffff;
            text-decoration: none;
            font-size: 16px;
            font-weight: 500;
            transition: all 0.3s ease;
            margin-bottom: 20px;
            padding: 10px 15px;
            border-radius: 10px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            opacity: 0;
            transform: translateX(-30px);
        }

        .back-button:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-2px);
            box-shadow: 0 5px 15px rgba(255, 255, 255, 0.1);
        }

        .welcome-text {
            text-align: center;
            margin-bottom: 15px;
        }

        .welcome-title {
            font-size: 36px;
            font-weight: 800;
            color: #ffffff;
            margin-bottom: 8px;
            opacity: 0;
            transform: translateY(20px);
        }

        .welcome-subtitle {
            font-size: 18px;
            color: rgba(255, 255, 255, 0.8);
            font-weight: 400;
            opacity: 0;
            transform: translateY(20px);
        }

        .form-container {
            padding: 35px 30px 40px;
            background: #ffffff;
        }

        .form-group {
            margin-bottom: 25px;
            opacity: 0;
            transform: translateY(30px);
        }

        .form-label {
            display: block;
            margin-bottom: 10px;
            color: #1f1f1f;
            font-weight: 700;
            font-size: 15px;
            letter-spacing: 0.025em;
        }

        .input-wrapper {
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 18px 22px;
            border: 2px solid #e0e0e0;
            border-radius: 14px;
            font-size: 16px;
            transition: all 0.4s ease;
            background: #fafafa;
            color: #1f1f1f;
            font-weight: 500;
        }

        .form-input:focus {
            outline: none;
            border-color: #000000;
            background: white;
            box-shadow: 0 0 0 4px rgba(0, 0, 0, 0.1);
            transform: translateY(-2px);
        }

        .form-input::placeholder {
            color: #888888;
            font-weight: 400;
        }

        .password-toggle {
            position: absolute;
            right: 18px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #666666;
            cursor: pointer;
            font-size: 18px;
            padding: 10px;
            border-radius: 8px;
            transition: all 0.3s ease;
        }

        .password-toggle:hover {
            background: #f0f0f0;
            color: #000000;
        }

        .phone-prefix {
            position: absolute;
            left: 22px;
            top: 50%;
            transform: translateY(-50%);
            color: #666666;
            font-weight: 600;
            pointer-events: none;
            z-index: 1;
        }

        .phone-input {
            padding-left: 65px;
        }

        .code-input {
            text-align: center;
            letter-spacing: 4px;
            font-size: 20px;
            font-weight: 700;
        }

        .signup-button {
            width: 100%;
            background: linear-gradient(135deg, #000000 0%, #333333 100%);
            color: white;
            padding: 18px 28px;
            border: none;
            border-radius: 14px;
            font-size: 17px;
            font-weight: 700;
            text-decoration: none;
            display: block;
            text-align: center;
            transition: all 0.4s ease;
            margin-bottom: 25px;
            cursor: pointer;
            letter-spacing: 0.5px;
            opacity: 0;
            transform: translateY(30px);
        }

        .signup-button:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.3);
            background: linear-gradient(135deg, #333333 0%, #000000 100%);
        }

        .signup-button:active {
            transform: translateY(-1px);
        }

        .login-text {
            text-align: center;
            color: #666666;
            font-size: 15px;
            opacity: 0;
            transform: translateY(20px);
        }

        .login-link {
            color: #000000;
            text-decoration: none;
            font-weight: 700;
            transition: all 0.3s ease;
            padding: 4px 8px;
            border-radius: 6px;
        }

        .login-link:hover {
            background: rgba(0, 0, 0, 0.1);
            color: #333333;
        }

        .strength-indicator {
            height: 6px;
            background: #e0e0e0;
            border-radius: 3px;
            margin-top: 10px;
            overflow: hidden;
            opacity: 0;
        }

        .strength-bar {
            height: 100%;
            width: 0%;
            background: #ff4444;
            transition: all 0.4s ease;
            border-radius: 3px;
        }

        .strength-weak { background: #ff4444; width: 33%; }
        .strength-medium { background: #ffaa00; width: 66%; }
        .strength-strong { background: #00aa00; width: 100%; }

        @media (max-width: 480px) {
            body {
                padding: 15px;
            }
            
            .signup-container {
                border-radius: 20px;
            }
            
            .header {
                padding: 25px 25px 20px;
            }
            
            .form-container {
                padding: 30px 25px 35px;
            }
            
            .welcome-title {
                font-size: 30px;
            }
            
            .form-input {
                padding: 16px 20px;
            }
            
            .phone-input {
                padding-left: 60px;
            }
            
            .phone-prefix {
                left: 20px;
            }
        }

        .floating-elements {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            pointer-events: none;
            z-index: -1;
        }

        .floating-circle {
            position: absolute;
            border-radius: 50%;
            background: rgba(255, 255, 255, 0.05);
        }
    </style>
        <style>
        /* Add this to your existing styles */
        .alert-message {
            padding: 12px 16px;
            border-radius: 10px;
            margin-bottom: 20px;
            font-size: 14px;
            display: none;
            opacity: 0;
            transform: translateY(-10px);
        }
        .alert-error {
            background-color: #ffebee;
            color: #c62828;
            border: 1px solid #ef9a9a;
        }
    </style>
</head>
<body>
    <div class="floating-elements">
        <div class="floating-circle" style="width: 100px; height: 100px; top: 10%; left: 10%;"></div>
        <div class="floating-circle" style="width: 150px; height: 150px; top: 60%; right: 10%;"></div>
        <div class="floating-circle" style="width: 80px; height: 80px; bottom: 20%; left: 20%;"></div>
        <div class="floating-circle" style="width: 120px; height: 120px; top: 30%; right: 30%;"></div>
    </div>

    <div class="signup-container">
        <div class="header">
            <a href="{{ route('login') }}" class="back-button">← Back</a>
            <div class="welcome-text">
                <h1 class="welcome-title">
                       <i class="fab fa-apple apple-icon"></i>
                </h1>
                <p class="welcome-subtitle">Create Account</p>
            </div>
        </div>
        
        <div class="form-container">
         <form method="POST" action="{{ route('register') }}">
                @csrf
                
                @if(request()->has('ref'))
                    <input type="hidden" name="referral_code" value="{{ request()->query('ref') }}">
                    <div class="alert alert-info mb-3">
                        You are registering using referral code: <strong>{{ request()->query('ref') }}</strong>
                    </div>
                @endif

                <!-- এরর মেসেজ ডিসপ্লে -->
                @if($errors->any())
                    <div class="alert-message alert-error" style="display: block; opacity: 1;">
                        @foreach($errors->all() as $error)
                            {{ $error }}<br>
                        @endforeach
                    </div>
                @endif
                
                <!-- ফোন নম্বর ইনপুট -->
                <div class="form-group">
                    <label class="form-label" for="phone">Phone Number</label>
                    <div class="input-wrapper">
                        <span class="phone-prefix">+88</span>
                        <input 
                            type="tel" 
                            id="phone" 
                            name="phone" 
                            class="form-input phone-input" 
                            placeholder="Your phone number"
                            required
                            value="{{ old('phone') }}"
                        >
                    </div>
                </div>

                <!-- পাসওয়ার্ড ইনপুট -->
                <div class="form-group">
                    <label class="form-label" for="password">Password</label>
                    <div class="input-wrapper">
                        <input 
                            type="password" 
                            id="password" 
                            name="password"
                            class="form-input" 
                            placeholder="Create password"
                            required
                        >
                        <span class="password-toggle" onclick="togglePassword('password')">👁️</span>
                    </div>
                </div>

                <!-- পাসওয়ার্ড কনফার্মেশন -->
                <div class="form-group">
                    <label class="form-label" for="confirmPassword">Confirm Password</label>
                    <div class="input-wrapper">
                        <input 
                            type="password" 
                            id="confirmPassword" 
                            name="password_confirmation"
                            class="form-input" 
                            placeholder="Confirm your password"
                            required
                        >
                        <span class="password-toggle" onclick="togglePassword('confirmPassword')">👁️</span>
                    </div>
                </div>

                <button type="submit" class="signup-button">Create Account</button>
            </form>

            <p class="login-text">
                Already have an account? 
                <a href="{{ route('login') }}" class="login-link">Login now</a>
            </p>
        </div>
    </div>

    <script>
        // শুধুমাত্র UI সম্পর্কিত ফাংশন রাখছি
        function togglePassword(fieldId) {
            const field = document.getElementById(fieldId);
            const button = field.nextElementSibling;
            
            if (field.type === 'password') {
                field.type = 'text';
                button.textContent = '🙈';
            } else {
                field.type = 'password';
                button.textContent = '👁️';
            }
            
            // এনিমেশন যোগ করছি
            gsap.to(button, {
                scale: 1.1,
                duration: 0.2,
                yoyo: true,
                repeat: 1
            });
        }

        // GSAP এনিমেশন ইনিশিয়ালাইজেশন
        gsap.timeline()
            .to('.signup-container', {
                opacity: 1,
                y: 0,
                duration: 0.8,
                ease: 'power3.out'
            })
            .to('.back-button', {
                opacity: 1,
                x: 0,
                duration: 0.6,
                ease: 'power2.out'
            }, '-=0.6')
            .to('.welcome-title', {
                opacity: 1,
                y: 0,
                duration: 0.6,
                ease: 'power2.out'
            }, '-=0.4')
            .to('.welcome-subtitle', {
                opacity: 1,
                y: 0,
                duration: 0.6,
                ease: 'power2.out'
            }, '-=0.4')
            .to('.form-group', {
                opacity: 1,
                y: 0,
                duration: 0.5,
                stagger: 0.1,
                ease: 'power2.out'
            }, '-=0.2')
            .to('.signup-button', {
                opacity: 1,
                y: 0,
                duration: 0.6,
                ease: 'power2.out'
            }, '-=0.3')
            .to('.login-text', {
                opacity: 1,
                y: 0,
                duration: 0.5,
                ease: 'power2.out'
            }, '-=0.2');

        // ফ্লোটিং এলিমেন্টস এনিমেশন
        gsap.to('.floating-circle', {
            y: -20,
            duration: 3,
            ease: 'power1.inOut',
            stagger: 0.5,
            repeat: -1,
            yoyo: true
        });
    </script>
</body>
</html>