<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Welcome Back</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
a{
    text-decoration: none;
}
        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif;
            background: #000000;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
            line-height: 1.6;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 40px rgba(255, 255, 255, 0.1);
            width: 100%;
            max-width: 420px;
            overflow: hidden;
            position: relative;
            animation: slideUp 0.6s ease-out;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .header {
            background: linear-gradient(135deg, #1f1f1f 0%, #000000 100%);
            padding: 30px 30px 20px;
            position: relative;
        }

        .back-button {
            display: inline-flex;
            align-items: center;
            color: #ffffff;
            text-decoration: none;
            font-size: 16px;
            font-weight: 500;
            transition: all 0.3s ease;
            margin-bottom: 20px;
            padding: 8px 12px;
            border-radius: 8px;
            border: 1px solid rgba(255, 255, 255, 0.2);
        }

        .back-button:hover {
            background: rgba(255, 255, 255, 0.1);
            transform: translateX(-2px);
        }

        .welcome-text {
            text-align: center;
            margin-bottom: 10px;
        }

        .welcome-title {
            font-size: 32px;
            font-weight: 700;
            color: #ffffff;
            margin-bottom: 8px;
        }

        .welcome-subtitle {
            font-size: 16px;
            color: rgba(255, 255, 255, 0.8);
            font-weight: 400;
        }

        .form-container {
            padding: 0 30px 40px;
        }

        .form-group {
            margin-bottom: 24px;
        }

        .form-label {
            display: block;
            margin-bottom: 8px;
            color: #1f1f1f;
            font-weight: 600;
            font-size: 14px;
            letter-spacing: 0.025em;
        }

        .input-wrapper {
            position: relative;
        }

        .form-input {
            width: 100%;
            padding: 16px 20px;
            border: 2px solid #e5e7eb;
            border-radius: 12px;
            font-size: 16px;
            transition: all 0.3s ease;
            background: #fafafa;
            color: #1f2937;
        }

        .form-input:focus {
            outline: none;
            border-color: #000000;
            background: white;
            box-shadow: 0 0 0 4px rgba(0, 0, 0, 0.1);
            transform: translateY(-1px);
        }

        .form-input::placeholder {
            color: #9ca3af;
        }

        .password-toggle {
            position: absolute;
            right: 16px;
            top: 50%;
            transform: translateY(-50%);
            background: none;
            border: none;
            color: #6b7280;
            cursor: pointer;
            font-size: 16px;
            padding: 8px;
            border-radius: 6px;
            transition: all 0.2s ease;
        }

        .password-toggle:hover {
            background: #f3f4f6;
            color: #000000;
        }

        .login-button {
            width: 100%;
            background: linear-gradient(135deg, #000000 0%, #333333 100%);
            color: white;
            padding: 16px 24px;
            border: none;
            border-radius: 12px;
            font-size: 16px;
            font-weight: 600;
            text-decoration: none;
            display: block;
            text-align: center;
            transition: all 0.3s ease;
            margin-bottom: 24px;
            cursor: pointer;
            letter-spacing: 0.025em;
        }

        .login-button:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.3);
        }

        .login-button:active {
            transform: translateY(0);
        }

        .signup-text {
            text-align: center;
            color: #6b7280;
            font-size: 14px;
        }

        .signup-link {
            color: #000000;
            text-decoration: none;
            font-weight: 600;
            transition: all 0.2s ease;
            padding: 2px 4px;
            border-radius: 4px;
        }

        .signup-link:hover {
            background: rgba(0, 0, 0, 0.1);
            color: #333333;
        }

        .phone-prefix {
            position: absolute;
            left: 20px;
            top: 50%;
            transform: translateY(-50%);
            color: #6b7280;
            font-weight: 500;
            pointer-events: none;
            z-index: 1;
        }

        .phone-input {
            padding-left: 60px;
        }

        @media (max-width: 480px) {
            body {
                padding: 15px;
            }
            
            .login-container {
                border-radius: 16px;
            }
            
            .header {
                padding: 25px 25px 15px;
            }
            
            .form-container {
                padding: 0 25px 35px;
            }
            
            .welcome-title {
                font-size: 28px;
            }
            
            .form-input {
                padding: 14px 18px;
            }
            
            .phone-input {
                padding-left: 55px;
            }
            
            .phone-prefix {
                left: 18px;
            }
        }

        .form-input:invalid:not(:focus):not(:placeholder-shown) {
            border-color: #ef4444;
            background: #fef2f2;
        }

        .form-input:valid:not(:focus):not(:placeholder-shown) {
            border-color: #000000;
        }

        .loading {
            opacity: 0.7;
            pointer-events: none;
        }

        .loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 20px;
            height: 20px;
            margin: -10px 0 0 -10px;
            border: 2px solid transparent;
            border-top: 2px solid white;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>

    
    <div class="login-container">
        <div class="header">
          
            <div class="welcome-text">
                <h1 class="welcome-title">Welcome</h1>
                <p class="welcome-subtitle">Login</p>
            </div>
        </div>
        
        <div class="form-container">
      <form id="loginForm" method="POST" action="{{ route('login') }}">
    @csrf

    @if ($errors->any())
        <div class="alert alert-danger" style="margin-bottom: 15px; color: red;">
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        </div>
    @endif

    <div class="form-group">
        <label class="form-label" for="phone">Phone Number</label>
        <div class="input-wrapper">
            <span class="phone-prefix">+88</span>
            <input 
                type="tel" 
                id="phone" 
                name="phone"
                class="form-input phone-input" 
                placeholder="Your phone number"
                value="{{ old('phone') }}"
                required
            >
        </div>
    </div>

    <div class="form-group">
        <label class="form-label" for="password">Password</label>
        <div class="input-wrapper">
            <input 
                type="password" 
                id="password" 
                name="password"
                class="form-input" 
                placeholder="Your login password"
                required
            >
            <span class="password-toggle" onclick="togglePassword()">👁️</span>
        </div>
    </div>
<div class="remember-me">
    <input type="checkbox" name="remember" id="remember">
    <label for="remember">আমাকে মনে রাখুন</label>
</div>
    <button type="submit" class="login-button">Login</button>
</form>




           <p class="signup-text">
    Don't have an account? 
    <a href="{{ route('register') }}" class="signup-link">Sign up now</a>
</p>

        </div>
    </div>

    <script>
        function togglePassword() {
            const passwordField = document.getElementById('password');
            const toggleButton = document.querySelector('.password-toggle');
            
            if (passwordField.type === 'password') {
                passwordField.type = 'text';
                toggleButton.textContent = '🙈';
            } else {
                passwordField.type = 'password';
                toggleButton.textContent = '👁️';
            }
        }

        function validateForm() {
            const phone = document.getElementById('phone').value.trim();
            const password = document.getElementById('password').value;
            
            if (!phone) {
                alert('Please enter your phone number');
                return false;
            }
            
            if (!password) {
                alert('Please enter your password');
                return false;
            }
            
            if (phone.length < 10) {
                alert('Please enter a valid phone number');
                return false;
            }
            
            return true;
        }

        function handleLogin(event) {
    if (!validateForm()) {
        event.preventDefault();
        return false;
    }
    
    // Get stored registration data
    const storedUser = localStorage.getItem('registeredUser');
    
    if (!storedUser) {
        alert('No registered user found. Please sign up first.');
        event.preventDefault();
        return false;
    }
    
    const registeredData = JSON.parse(storedUser);
    const enteredPhone = '+88' + document.getElementById('phone').value;
    const enteredPassword = document.getElementById('password').value;
    
    // Check if credentials match
    if (enteredPhone !== registeredData.phone || enteredPassword !== registeredData.password) {
        alert('Invalid phone number or password. Please check your credentials.');
        event.preventDefault();
        return false;
    }
    
    // Add loading state
    const loginBtn = document.getElementById('loginBtn');
    loginBtn.classList.add('loading');
    loginBtn.textContent = 'Logging in...';
    
    // Log successful login
    console.log('Login successful for:', enteredPhone);
    
    // Simulate loading delay then allow navigation
    setTimeout(() => {
        window.location.href = 'index.html';
    }, 1000);
    
    event.preventDefault(); // Prevent immediate navigation to show loading
    return false;
}

        // Phone number formatting
        document.getElementById('phone').addEventListener('input', function() {
            let value = this.value.replace(/\D/g, '');
            
            // Limit to reasonable phone number length
            if (value.length > 11) {
                value = value.substring(0, 11);
            }
            
            this.value = value;
        });

      
        // Add smooth focus animations
        document.querySelectorAll('.form-input').forEach(input => {
            input.addEventListener('focus', function() {
                this.parentElement.style.transform = 'scale(1.02)';
            });
            
            input.addEventListener('blur', function() {
                this.parentElement.style.transform = 'scale(1)';
            });
        });

        // Check if user is already registered when page loads
window.addEventListener('load', function() {
    const storedUser = localStorage.getItem('registeredUser');
    if (storedUser) {
        const userData = JSON.parse(storedUser);
        console.log('Registered user found:', userData.phone);
    }
});
    </script>
</body>
</html>