@extends('admin.admin_master')
@section('main')
<style>
    .investment-card {
        border-left: 4px solid #FFD700;
        transition: all 0.3s ease;
    }
    .investment-card:hover {
        transform: translateY(-3px);
        box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    }
    .progress-thin {
        height: 5px;
    }
    .vip-badge {
        background: linear-gradient(90deg, #FFD700, #FFC107, #FFD700);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        font-weight: bold;
    }
</style>

<div class="container">
    <div class="page-inner">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row pt-2 pb-4">
            <div>
                <h3 class="fw-bold mb-3">VIP Member Details</h3>
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.vip.members') }}">VIP Members</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{ $member->name }}</li>
                    </ol>
                </nav>
            </div>
            <div class="ms-md-auto py-2 py-md-0">
                <span class="badge bg-gold text-dark">
                    <i class="fas fa-crown me-1"></i>
                    VIP Member Since {{ $member->created_at->format('M Y') }}
                </span>
            </div>
        </div>
        
        <div class="row">
            <!-- Member Profile -->
            <div class="col-md-4">
                <div class="card">
                    <div class="card-body text-center">
                        <div class="avatar avatar-xxl mb-3">
                            <span class="avatar-title rounded-circle bg-primary text-white" style="font-size: 2rem;">
                                {{ strtoupper(substr($member->name, 0, 2)) }}
                            </span>
                        </div>
                        <h3>{{ $member->name }}</h3>
                        <p class="text-muted">{{ $member->email }}</p>
                        <p><i class="fas fa-phone me-2"></i> {{ $member->phone }}</p>
                        
                        <div class="d-flex justify-content-center mt-3">
                            <div class="mx-3 text-center">
                                <h5 class="mb-0">{{ $member->vipInvestments()->active()->count() }}</h5>
                                <small class="text-muted">Active Plans</small>
                            </div>
                            <div class="mx-3 text-center">
                                <h5 class="mb-0">${{ number_format($member->vipInvestments()->active()->sum('amount'), 2) }}</h5>
                                <small class="text-muted">Invested</small>
                            </div>
                            <div class="mx-3 text-center">
                                <h5 class="mb-0">${{ number_format($member->vipInvestments()->active()->sum('daily_earnings'), 2) }}</h5>
                                <small class="text-muted">Daily Earnings</small>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Account Summary -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title">Account Summary</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Current Balance
                                <span class="fw-bold">${{ number_format($member->balance, 2) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Total Earnings
                                <span class="fw-bold text-success">${{ number_format($member->total_earnings, 2) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Total Withdrawals
                                <span class="fw-bold text-danger">${{ number_format($member->total_withdrawals, 2) }}</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Referral Team
                                <span class="fw-bold">{{ $member->team_size }} members</span>
                            </li>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                Account Status
                                <span class="badge bg-{{ $member->status ? 'success' : 'danger' }}">
                                    {{ $member->status ? 'Active' : 'Inactive' }}
                                </span>
                            </li>
                        </ul>
                    </div>
                </div>
                
                <!-- Quick Actions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="card-title">Quick Actions</h5>
                    </div>
                    <div class="card-body">
                        <div class="d-grid gap-2">
                            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#adjustBalanceModal">
                                <i class="fas fa-coins me-2"></i> Adjust Balance
                            </button>
                            <a href="mailto:{{ $member->email }}" class="btn btn-info">
                                <i class="fas fa-envelope me-2"></i> Send Email
                            </a>
                            <button class="btn btn-warning">
                                <i class="fas fa-bell me-2"></i> Send Notification
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Investments and Activity -->
            <div class="col-md-8">
                <!-- Active Investments -->
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title">Active VIP Investments</h4>
                        <span class="badge bg-primary">
                            {{ $member->vipInvestments()->active()->count() }} Active
                        </span>
                    </div>
                    <div class="card-body">
                        @if($member->vipInvestments()->active()->count() > 0)
                            <div class="row">
                                @foreach($member->vipInvestments()->active()->with('product')->get() as $investment)
                                <div class="col-md-6 mb-3">
                                    <div class="card investment-card h-100">
                                        <div class="card-body">
                                            <div class="d-flex justify-content-between align-items-start">
                                                <div>
                                                    <h5 class="card-title">{{ $investment->product->investment_tool }}</h5>
                                                    <h6 class="text-success mb-3">${{ number_format($investment->amount, 2) }}</h6>
                                                </div>
                                                <span class="badge bg-success">
                                                    Active
                                                </span>
                                            </div>
                                            
                                            <div class="mb-3">
                                                <div class="d-flex justify-content-between mb-1">
                                                    <small>Daily Earnings: ${{ number_format($investment->daily_earnings, 2) }}</small>
                                                    <small>{{ $investment->created_at->diffInDays($investment->expires_at) }} days</small>
                                                </div>
                                                @php
                                                    $progress = min(100, $investment->created_at->diffInDays(now()) / $investment->created_at->diffInDays($investment->expires_at) * 100);
                                                @endphp
                                                <div class="progress progress-thin">
                                                    <div class="progress-bar bg-success" role="progressbar" 
                                                         style="width: {{ $progress }}%" 
                                                         aria-valuenow="{{ $progress }}" 
                                                         aria-valuemin="0" 
                                                         aria-valuemax="100">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="row text-center">
                                                <div class="col-6">
                                                    <small class="text-muted">Started</small>
                                                    <p class="mb-0">{{ $investment->created_at->format('M d, Y') }}</p>
                                                </div>
                                                <div class="col-6">
                                                    <small class="text-muted">Expires</small>
                                                    <p class="mb-0">{{ $investment->expires_at->format('M d, Y') }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        @else
                            <div class="alert alert-warning">
                                This member has no active VIP investments.
                            </div>
                        @endif
                    </div>
                </div>
                
                <!-- Transaction History -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h4 class="card-title">Recent Transactions</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm">
                                <thead>
                                    <tr>
                                        <th>Date</th>
                                        <th>Type</th>
                                        <th>Amount</th>
                                        <th>Status</th>
                                        <th>Details</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($member->transactions()->latest()->take(10)->get() as $transaction)
                                    <tr>
                                        <td>{{ $transaction->created_at->format('M d, Y') }}</td>
                                        <td>
                                            <span class="badge 
                                                @if($transaction->type === 'deposit') badge-success
                                                @elseif($transaction->type === 'withdrawal') badge-danger
                                                @elseif($transaction->type === 'vip_investment') badge-primary
                                                @elseif($transaction->type === 'vip_earnings') badge-warning
                                                @else badge-info @endif">
                                                {{ ucfirst($transaction->type) }}
                                            </span>
                                        </td>
                                        <td>${{ number_format($transaction->amount, 2) }}</td>
                                        <td>
                                            <span class="badge 
                                                @if($transaction->status == 'approved') bg-success
                                                @elseif($transaction->status == 'pending') bg-warning
                                                @else bg-danger @endif">
                                                {{ ucfirst($transaction->status) }}
                                            </span>
                                        </td>
                                        <td>{{ $transaction->notes }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Adjust Balance Modal -->
<div class="modal fade" id="adjustBalanceModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Adjust Balance</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.users.updateBalance', $member->id) }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Amount</label>
                        <input type="number" step="0.01" class="form-control" name="amount" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Action</label>
                        <select class="form-select" name="type" required>
                            <option value="add">Add to Balance</option>
                            <option value="subtract">Subtract from Balance</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Notes</label>
                        <textarea class="form-control" name="notes" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection