@extends('admin.admin_master')
@section('main')

<div class="container mt-4">
    <div class="page-inner">
        <div class="page-header">
            <h4>
                <i class="fas fa-{{ isset($category) ? 'edit' : 'plus' }} me-2"></i>
                {{ isset($category) ? 'Edit' : 'Create' }} VIP Category
            </h4>
        </div>

        <div class="row">
            <div class="col-md-8">
                @if($errors->any())
                    <div class="alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="fas fa-exclamation-circle me-2"></i> Please fix the following errors
                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        <ul class="mt-2 mb-0">
                            @foreach($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="card">
                    <div class="card-body">
                        <form method="POST" action="{{ isset($category) ? route('admin.vip-categories.update', $category->id) : route('admin.vip-categories.store') }}">
                            @csrf
                            @if(isset($category)) @method('PUT') @endif

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Category Code</label>
                                    <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                           name="name" value="{{ old('name', $category->name ?? '') }}" 
                                           placeholder="e.g. V1, V2" required>
                                    @error('name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="text-muted">Unique short code identifier</small>
                                </div>
                                
                                <div class="col-md-6">
                                    <label class="form-label">Display Name</label>
                                    <input type="text" class="form-control @error('display_name') is-invalid @enderror" 
                                           name="display_name" value="{{ old('display_name', $category->display_name ?? '') }}" 
                                           placeholder="e.g. V1 Premium" required>
                                    @error('display_name')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                    <small class="text-muted">Name shown to users</small>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Icon</label>
                                <select class="form-select @error('icon') is-invalid @enderror" name="icon" required>
                                    <option value="star" {{ old('icon', $category->icon ?? '') == 'star' ? 'selected' : '' }}>Star (fas fa-star)</option>
                                    <option value="crown" {{ old('icon', $category->icon ?? '') == 'crown' ? 'selected' : '' }}>Crown (fas fa-crown)</option>
                                 
                                </select>
                                @error('icon')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="text-muted">Select an icon for this category</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Description</label>
                                <textarea class="form-control @error('description') is-invalid @enderror" 
                                          name="description" rows="3"
                                          placeholder="Category description">{{ old('description', $category->description ?? '') }}</textarea>
                                @error('description')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            @if(isset($category))
                            <div class="mb-3">
                                <div class="form-check form-switch">
                                    <input type="checkbox" class="form-check-input" name="is_active" 
                                           id="is_active" {{ old('is_active', $category->is_active ?? true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">Active Status</label>
                                </div>
                                <small class="text-muted">Toggle to enable/disable this category</small>
                            </div>
                            @endif

                            <div class="d-flex justify-content-between mt-4">
                                <a href="{{ route('admin.vip-categories.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i> Back to List
                                </a>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save me-1"></i> {{ isset($category) ? 'Update' : 'Save' }} Category
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .form-control:focus, .form-select:focus {
        border-color: #4e73df;
        box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
    }
    .form-check-input:checked {
        background-color: #4e73df;
        border-color: #4e73df;
    }
    .invalid-feedback {
        display: block;
    }
</style>

@endsection