@extends('admin.admin_master')

@section('main')
<div class="card">
    <div class="card-header">
        <h4 class="card-title">ভিআইপি পেন্ডিং আয়ের তালিকা</h4>
    </div>
    <div class="card-body">
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        @if($pendingInvestments->isEmpty()))
            <div class="alert alert-info">কোন পেন্ডিং আয় পাওয়া যায়নি</div>
        @else
            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>ইউজার</th>
                            <th>প্রোডাক্ট</th>
                            <th>আয়ের পরিমাণ</th>
                            <th>শেষ পেমেন্ট</th>
                            <th>বাকি সময়</th>
                            <th>স্ট্যাটাস</th>
                            <th>অ্যাকশন</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($pendingInvestments as $investment)
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                @if($investment->user)
                                    {{ $investment->user->name }}
                                @else
                                    ইউজার পাওয়া যায়নি
                                @endif
                            </td>
                            <td>
                                @if($investment->product)
                                    {{ $investment->product->investment_tool }}
                                @else
                                    প্রোডাক্ট পাওয়া যায়নি
                                @endif
                            </td>
                            <td>{{ number_format($investment->daily_earnings, 2) }} ৳</td>
                            <td>
                                @if($investment->last_payout_at)
                                    {{ $investment->last_payout_at->format('d M Y h:i A') }}
                                @else
                                    প্রথম বার
                                @endif
                            </td>
                            <td>
                                @if($investment->last_payout_at)
                                    @php
                                        $nextPayoutTime = $investment->last_payout_at->addHours(24);
                                        $remainingTime = now()->diff($nextPayoutTime);
                                    @endphp
                                    
                                    @if(now() >= $nextPayoutTime)
                                        <span class="badge badge-success">প্রস্তুত</span>
                                    @else
                                        {{ $remainingTime->format('%h ঘণ্টা %i মিনিট') }}
                                    @endif
                                @else
                                    <span class="badge badge-success">প্রস্তুত</span>
                                @endif
                            </td>
                            <td>
                                @if($investment->expires_at <= now())
                                    <span class="badge badge-danger">মেয়াদ শেষ</span>
                                @elseif(!$investment->is_active)
                                    <span class="badge badge-secondary">নিষ্ক্রিয়</span>
                                @else
                                    <span class="badge badge-success">সক্রিয়</span>
                                @endif
                            </td>
                            <td>
                                @if($investment->is_active && $investment->expires_at > now() && (!$investment->last_payout_at || $investment->last_payout_at <= now()->subHours(24)))
                                <form action="{{ route('admin.vip.process-single-earning', $investment->id) }}" method="POST">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        প্রসেস করুন
                                    </button>
                                </form>
                                @else
                                <button class="btn btn-sm btn-secondary" disabled>প্রসেস করুন</button>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>
</div>
@endsection