<div class="table-responsive mt-4">
    @if(session()->has('message'))
    <div class="alert alert-{{ session('alert-type') }} alert-dismissible fade show" role="alert">
        {{ session('message') }}
        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span>
        </button>
    </div>
    @endif

    <table class="table table-bordered table-hover">
        <thead class="bg-primary text-white">
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Type</th>
                <th>Amount</th>
                <th>Method</th>
                <th>Transaction ID</th>
                <th>Status</th>
                <th>Date</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($transactions as $transaction)
            <tr>
                <td>{{ $transaction->id }}</td>
               <td>{{ $transaction->user?->name ?? 'Unknown User' }}</td>

                <td>
                    <span class="badge {{ $transaction->type == 'deposit' ? 'bg-success' : 'bg-warning' }}">
                        {{ ucfirst($transaction->type) }}
                    </span>
                </td>
                <td>৳{{ number_format($transaction->amount, 2) }}</td>
                <td>{{ ucfirst($transaction->method) }}</td>
                <td>{{ $transaction->transaction_id }}</td>
                <td>
                    <form action="{{ route('admin.transactions.status', $transaction) }}" method="POST">
                        @csrf
                        <select name="status" 
                                class="form-select form-select-sm status-select"
                                onchange="this.form.submit()"
                                style="min-width: 100px;">
                            <option value="pending" {{ $transaction->status == 'pending' ? 'selected' : '' }}>Pending</option>
                            <option value="approved" {{ $transaction->status == 'approved' ? 'selected' : '' }}>Approved</option>
                            <option value="rejected" {{ $transaction->status == 'rejected' ? 'selected' : '' }}>Rejected</option>
                        </select>
                    </form>
                </td>
                <td>{{ $transaction->created_at->format('d M Y h:i A') }}</td>
                <td>
                    <form action="{{ route('admin.transactions.destroy', $transaction) }}" method="POST">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this transaction?')">
                            <i class="fas fa-trash"></i>
                        </button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>

    {{ $transactions->links() }}
</div>

<script>
// Simple confirmation before status change
document.querySelectorAll('.status-select').forEach(select => {
    select.addEventListener('change', function() {
        if (!confirm('Are you sure you want to change the status?')) {
            this.form.reset();
        }
    });
});
</script>