@extends('admin.admin_master')
@section('main')
@php
use App\Models\Setting;
@endphp
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Site Settings</h3>
                </div>
                <form action="{{ route('admin.settings.update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h4>General Settings</h4>
                                
                                <div class="form-group">
                                    <label>Site Name</label>
                                    <input type="text" name="site_name" class="form-control" 
                                           value="{{ Setting::getValue('site_name') }}">
                                </div>

                                <div class="form-group">
                                    <label>Site Logo</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" name="site_logo" class="custom-file-input">
                                            <label class="custom-file-label">Choose file</label>
                                        </div>
                                    </div>
                                    @if(Setting::getValue('site_logo'))
    <img src="{{ asset(Setting::getValue('site_logo')) }}" height="80" class="mt-2">
@endif
                                </div>

                                <div class="form-group">
                                    <label>Favicon</label>
                                    <div class="input-group">
                                        <div class="custom-file">
                                            <input type="file" name="site_favicon" class="custom-file-input">
                                            <label class="custom-file-label">Choose file</label>
                                        </div>
                                    </div>
                                   @if(Setting::getValue('site_favicon'))
    <img src="{{ asset(Setting::getValue('site_favicon')) }}" height="80" class="mt-2">
@endif
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h4>Contact Information</h4>
                                
                                <div class="form-group">
                                    <label>Contact Email</label>
                                    <input type="email" name="contact_email" class="form-control" 
                                           value="{{ Setting::getValue('contact_email') }}">
                                </div>

                                <div class="form-group">
                                    <label>Contact Phone</label>
                                    <input type="text" name="contact_phone" class="form-control" 
                                           value="{{ Setting::getValue('contact_phone') }}">
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save Settings</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    // Display the name of the file on select
    document.querySelectorAll('.custom-file-input').forEach(function(input) {
        input.addEventListener('change', function(e) {
            var fileName = e.target.files[0].name;
            var nextSibling = e.target.nextElementSibling;
            nextSibling.innerText = fileName;
        });
    });
</script>
@endsection