@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Global SEO Settings</h3>
        </div>
        <form action="{{ route('admin.seo.save-global') }}" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="card-body">
                <div class="form-group">
                    <label>Default Meta Title</label>
                    <input type="text" name="meta_title" class="form-control" 
                           value="{{ old('meta_title', $globalSeo->meta_title) }}" required>
                    <small>Recommended: 50-60 characters</small>
                </div>

                <div class="form-group">
                    <label>Default Meta Description</label>
                    <textarea name="meta_description" class="form-control" rows="3" required>
                        {{ old('meta_description', $globalSeo->meta_description) }}
                    </textarea>
                    <small>Recommended: 150-160 characters</small>
                </div>

                <div class="form-group">
                    <label>Default Keywords</label>
                    <input type="text" name="meta_keywords" class="form-control" 
                           value="{{ old('meta_keywords', $globalSeo->meta_keywords) }}" required>
                    <small>Comma separated list</small>
                </div>

                <div class="form-group">
                    <label>Default OG Image</label>
                    <input type="file" name="og_image" class="form-control-file">
                    @if($globalSeo->og_image)
                        <img src="{{ $globalSeo->og_image }}" height="100" class="mt-2 d-block">
                    @endif
                </div>
            </div>
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Save Global Settings</button>
            </div>
        </form>
    </div>
</div>
@endsection