@extends('admin.admin_master')

@section('main')

<div class="container my-4">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white">
            <h2 class="mb-0">All Admins</h2>
        </div>
        <div class="card-body">
            <table class="table table-bordered table-hover table-striped align-middle">
                <thead class="table-dark">
                    <tr>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th class="text-center">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($admins as $admin)
                    <tr>
                        <td>{{ $admin->name }}</td>
                        <td>{{ $admin->email }}</td>
                        <td>
                            <span class="badge {{ $admin->status === 'active' ? 'bg-success' : 'bg-secondary' }}">
                                {{ ucfirst($admin->status) }}
                            </span>
                        </td>
                        <td class="text-center">
                            <a href="{{ route('admin.edit', $admin->id) }}" class="btn btn-sm btn-warning me-2">Edit</a>
                            <a href="{{ route('admin.delete', $admin->id) }}" class="btn btn-sm btn-danger">Delete</a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>

@endsection
