@extends('admin.admin_master')
@section('main')
<div class="container-fluid">
    <div class="page-header">
        <div class="row align-items-center">
            <div class="col">
                <h4>
                    <i class="fas fa-credit-card me-2"></i>
                    Payment Methods Management
                </h4>
            </div>
            <div class="col-auto">
                <a href="{{ route('admin.payment-methods.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-1"></i> Add New Method
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <table class="table table-hover" id="methodsTable">
                            <thead>
                                <tr>
                                    <th width="50">#</th>
                                    <th>Method Name</th>
                                    <th>Account Number</th>
                                    <th>Description</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($methods as $method)
                                <tr data-id="{{ $method->id }}">
                                    <td>{{ $loop->iteration }}</td>
                                   
                                    <td>
                                        <div class="d-flex align-items-center">
                                            @if($method->icon)
                                            <img src="{{ asset($method->icon) }}" alt="{{ $method->name }}" 
                                                 class="img-thumbnail" style="width: 40px; height: 40px; object-fit: contain;">
                                            @endif
                                            <span class="ms-2">{{ $method->name }}</span>
                                        </div>
                                    </td>
                                    <td>{{ $method->account_number }}</td>
                                    <td>{{ $method->description ?: 'N/A' }}</td>
                                    <td>
                                        <div class="form-check form-switch">
                                            <input class="form-check-input status-toggle" type="checkbox" 
                                                   data-id="{{ $method->id }}"
                                                   id="status_{{ $method->id }}" 
                                                   {{ $method->is_active ? 'checked' : '' }}>
                                            <label class="form-check-label" for="status_{{ $method->id }}">
                                                {{ $method->is_active ? 'Active' : 'Inactive' }}
                                            </label>
                                        </div>
                                    </td>
                                    <td>
                                        <a href="{{ route('admin.payment-methods.edit', $method->id) }}" 
                                           class="btn btn-sm btn-primary">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.payment-methods.destroy', $method->id) }}" method="POST" onsubmit="return confirm('Are you sure?')" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="6" class="text-center">No payment methods found. <a href="{{ route('admin.payment-methods.create') }}">Add your first method</a></td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog">
    <form id="deleteForm" method="POST">
      @csrf
      @method('DELETE')

      <div class="modal-content">
        <div class="modal-header bg-danger text-white">
          <h5 class="modal-title">Confirm Deletion</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <p>Are you sure you want to delete this payment method? This action cannot be undone.</p>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
          <button type="submit" class="btn btn-danger">Delete</button>
        </div>
      </div>
    </form>
  </div>
</div>

@endsection

@push('styles')
<style>
    .img-thumbnail {
        padding: 0.15rem;
    }
    .table-responsive {
        min-height: 200px;
    }
    .modal-header.bg-danger {
        background-color: #dc3545 !important;
    }
    .btn-close-white {
        filter: invert(1) grayscale(100%) brightness(200%);
    }
    /* Add ellipsis for long descriptions */
    td {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<script>
$(document).ready(function() {
    // Delete button click handler
    let deleteMethodId;

    $(document).on('click', '.delete-method', function() {
        deleteMethodId = $(this).data('id');
        const deleteUrl = "{{ route('admin.payment-methods.destroy', ':id') }}".replace(':id', deleteMethodId);
        $('#deleteForm').attr('action', deleteUrl);
    });

    // Status toggle handler
    $('.status-toggle').change(function() {
        const methodId = $(this).data('id');
        const isActive = $(this).is(':checked') ? 1 : 0;
        
        $.ajax({
            url: "",
            method: 'POST',
            data: {
                id: methodId,
                is_active: isActive,
                _token: "{{ csrf_token() }}"
            },
            success: function(response) {
                toastr.success('Status updated successfully');
            },
            error: function(xhr) {
                toastr.error('Error updating status');
                // Revert the toggle if there's an error
                $('.status-toggle[data-id="' + methodId + '"]').prop('checked', !isActive);
            }
        });
    });

    // Confirm delete via AJAX
    $('#deleteForm').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const actionUrl = form.attr('action');

        $.ajax({
            url: actionUrl,
            type: 'POST',
            data: form.serialize(),
            success: function(response) {
                $('#deleteModal').modal('hide');
                toastr.success(response.message || 'Payment method deleted successfully');
                setTimeout(() => window.location.reload(), 1000);
            },
            error: function(xhr) {
                toastr.error(xhr.responseJSON?.message || 'Error deleting payment method');
            }
        });
    });
});
</script>
@endpush