@extends('admin.admin_master')
@section('main')

<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>

<div class="container">
    <div class="page-inner">
        <div class="page-header mb-4 text-center">
            <h3 class="fw-bold text-uppercase">Terms & Conditions Page</h3>
        </div>
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow-lg">
                    <div class="card-body">
                        <form action="{{ route('terms.store') }}" method="POST">
                            @csrf

                            <div class="form-group mb-4">
                                <label for="title" class="form-label">Page Title <span class="text-danger">*</span></label>
                                <input type="text" name="title" class="form-control form-control-lg" value="{{ old('title', $terms->title ?? '') }}" placeholder="Enter page title" required />
                            </div>

                            <div class="form-group mb-4">
                                <label for="content" class="form-label">Terms & Conditions Content <span class="text-danger">*</span></label>
                                <textarea id="summernote" name="content" class="form-control form-control-lg" placeholder="Enter content here..." required>{{ old('content', $terms->content ?? '') }}</textarea>
                            </div>

                            <div class="form-group text-center">
                                <button type="submit" class="btn btn-success btn-lg px-5">Update Terms & Conditions</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('#summernote').summernote({
            height: 300,
            placeholder: 'Write the terms content here...',
            tabsize: 2
        });
    });
</script>

@endsection
