@extends('admin.admin_master')

@section('main')

<!-- Include Summernote CSS and JS -->
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>

<div class="container">
    <div class="page-inner">
        <!-- Success Message -->
        @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
        @endif

        <div class="page-header mb-4 text-center">
            <h3 class="fw-bold text-uppercase">Update Footer Settings</h3>
        </div>
        
        <!-- Form Content -->
        <div class="row justify-content-center">
            <div class="col-md-10">
                <div class="card shadow-lg">
                    <div class="card-body">
                        <!-- Form with multipart for file upload -->
                        <form action="{{ route('footer.update') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            
                            <!-- Logo Upload Field -->
                            <div class="form-group mb-3">
                                <label for="logo" class="form-label">Logo</label>
                                <input type="file" name="logo" id="logo" class="form-control">
                                
                                @if(!empty($footerSetting->logo))
                                    <img src="{{ asset($footerSetting->logo) }}" alt="Logo" class="mt-2" width="100">
                                @endif
                            </div>


                            <!-- Description with Summernote Editor -->
                            <div class="form-group mb-3">
                                <label for="description" class="form-label">Description</label>
                                <textarea name="description" id="description" class="form-control summernote">{{ $footerSetting->description ?? '' }}</textarea>
                            </div>

                            <!-- Social Media Links -->
                            <div class="form-group mb-3">
                                <label for="facebook_link" class="form-label">Facebook Link</label>
                                <input type="text" name="facebook_link" id="facebook_link" class="form-control" value="{{ $footerSetting->facebook_link ?? '' }}">
                            </div>

                            <div class="form-group mb-3">
                                <label for="youtube_link" class="form-label">YouTube Link</label>
                                <input type="text" name="youtube_link" id="youtube_link" class="form-control" value="{{ $footerSetting->youtube_link ?? '' }}">
                            </div>

                            <div class="form-group mb-3">
                                <label for="twitter_link" class="form-label">Twitter Link</label>
                                <input type="text" name="twitter_link" id="twitter_link" class="form-control" value="{{ $footerSetting->twitter_link ?? '' }}">
                            </div>

                            <div class="form-group mb-3">
                                <label for="linkedin_link" class="form-label">LinkedIn Link</label>
                                <input type="text" name="linkedin_link" id="linkedin_link" class="form-control" value="{{ $footerSetting->linkedin_link ?? '' }}">
                            </div>

                            <div class="form-group mb-3">
                                <label for="github_link" class="form-label">GitHub Link</label>
                                <input type="text" name="github_link" id="github_link" class="form-control" value="{{ $footerSetting->github_link ?? '' }}">
                            </div>

                            <!-- Submit Button -->
                            <div class="form-group text-center">
                                <button type="submit" class="btn btn-success btn-lg px-5">Save Settings</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Initialize Summernote -->
<script>
    $(document).ready(function() {
        $('.summernote').summernote({
            height: 300, // Editor height
            placeholder: 'Write the footer description here...',
            tabsize: 2
        });
    });
</script>

@endsection
