@extends('admin.admin_master')
@section('main')
<div class="container">
    <div class="row justify-content-center">
        <div class="col-md-8">
            @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                {{ session('success') }}
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif

            <div class="card">
                <div class="card-header">
                    <h4>About Settings</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.about.update') }}">
                        @csrf
                        @method('PUT') <!-- Add this for update requests -->

                        <div class="form-group mb-3">
                            <label for="description">About Text</label>
                            <textarea class="form-control" id="description" name="description" rows="3" required>{{ $about->description ?? '' }}</textarea>
                        </div>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Alert টি 5 সেকেন্ড পর অটোমেটিক বন্ধ হয়ে যাবে
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
</script>
@endsection