<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_vip_investments', function (Blueprint $table) {
            $table->id();
             $table->foreignId('user_id')->constrained()->onDelete('cascade');
    $table->foreignId('vip_product_id')->constrained()->onDelete('cascade');
    $table->decimal('amount', 10, 2);
    $table->decimal('daily_earnings', 10, 2);
    $table->timestamp('last_payout_at')->nullable();
  $table->timestamp('expires_at')->useCurrent();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_vip_investments');
    }
};
