<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
             $table->boolean('status')->default(true)->after('is_active');
            $table->integer('order')->default(0)->after('status');
            $table->decimal('min_withdraw', 10, 2)->nullable()->after('order');
            $table->decimal('max_withdraw', 10, 2)->nullable()->after('min_withdraw');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('payment_methods', function (Blueprint $table) {
            $table->dropColumn(['status', 'order', 'min_withdraw', 'max_withdraw']);
        });
    }
};
