<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use App\Models\UserVipInvestment;

class InvestmentCompletedNotification extends Notification
{
    use Queueable;

    protected $investment;

    public function __construct(UserVipInvestment $investment)
    {
        $this->investment = $investment;
    }

    public function via($notifiable)
    {
        return ['database'];
    }

    public function toArray($notifiable)
    {
        return [
            'message' => 'আপনার '.$this->investment->product->investment_tool.' বিনিয়োগ সম্পূর্ণ হয়েছে',
            'amount' => $this->investment->amount,
            'investment_id' => $this->investment->id,
            'link' => '/investments'
        ];
    }
}