<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
class Transaction extends Model
{
    use HasFactory, SoftDeletes;

    const TYPE_DEPOSIT = 'deposit';
    const TYPE_WITHDRAWAL = 'withdrawal';
    const TYPE_VIP_INVESTMENT = 'vip_investment';
    const TYPE_VIP_EARNINGS = 'vip_earnings';
    const TYPE_REFERRAL_BONUS = 'referral_bonus';

  protected $fillable = [
    'user_id', 
    'type', 
    'amount', 
    'method', 
    'transaction_id', 
    'status', 
    'notes' // Make sure this is included
];

    protected $casts = [
        'amount' => 'float',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'method', 'name');
    }

    
}