<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SeoMeta extends Model
{
    use HasFactory;

     protected $fillable = [
        'metaable_id',
        'metaable_type',
        'meta_title',
        'meta_description',
        'meta_keywords',
        'og_title',
        'og_description',
        'og_image',
        'canonical_url'
    ];

    // In app/Models/SeoMeta.php
public function metaable()
{
    return $this->morphTo();
}

// Add this method
public function getMetaableTypeAttribute($value)
{
    if ($value === 'global') {
        return null;
    }
    return $value;
}

    public static function getForModel($model)
    {
        return self::firstOrCreate([
            'metaable_id' => $model->id,
            'metaable_type' => get_class($model)
        ]);
    }
}
