<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PaymentMethod extends Model
{
    use HasFactory;
  protected $fillable = [
        'name',
        'icon',
        'account_number',
        'is_active',
        'sort_order',
        'description',
        'status',
        'order',
        'min_withdraw',
        'max_withdraw'
    ];
    
    protected $casts = [
        'is_active' => 'boolean',
        'status' => 'boolean',
        'min_withdraw' => 'decimal:2',
        'max_withdraw' => 'decimal:2'
    ];

   public function withdrawals()
{
    return $this->hasMany(Withdrawal::class);
}
}
