<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class AutoLogin
{
    public function handle(Request $request, Closure $next): Response
    {
        // যদি ইউজার লগইন না থাকে কিন্তু "Remember Me" কুকি থাকে
        if (!Auth::check() && $request->hasCookie('remember_me')) {
            Auth::loginUsingId($request->cookie('remember_me'));
        }

        return $next($request);
    }
}