<?php

namespace App\Http\Controllers\Frontend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Transaction;
use App\Models\PaymentMethod;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;


class TransactionController extends Controller
{
     // ক্যাশ ইন পেজ
    public function deposit()
    {
          $paymentMethods = PaymentMethod::where('is_active', true)
                            ->orderBy('sort_order')
                            ->get();
         $lastDeposit = Transaction::where('type', 'deposit')
                    ->where('status', 'approved')
                    ->latest()
                    ->first();
        return view('user.transactions.deposit', compact('paymentMethods','lastDeposit',)  );
    }

public function depositStore(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:100',
            'method' => 'required|string',
            'transaction_id' => 'required|string'
        ]);

        DB::beginTransaction();

        try {
            $user = Auth::user();
            
            // Create pending transaction record
            $transaction = Transaction::create([
                'user_id' => $user->id,
                'type' => 'deposit',
                'amount' => $request->amount,
                'method' => $request->method,
                'transaction_id' => $request->transaction_id,
                'status' => 'pending', // পেন্ডিং হিসেবে রাখছি
                'notes' => 'অ্যাডমিন অ্যাপ্রুভালের অপেক্ষায়'
            ]);

            // এখানে অটো অ্যাপ্রুভ করছি না
            // $this->approveDeposit($transaction); // এই লাইন রিমুভ করেছি

            DB::commit();

            return response()->json([
                'success' => true,
                'message' => 'ডিপোজিট অনুরোধ সফলভাবে জমা হয়েছে! অ্যাডমিন যাচাই করার পর ব্যালেন্স আপডেট করা হবে।',
                'transaction' => $transaction
            ]);

        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'success' => false,
                'message' => 'ত্রুটি: ' . $e->getMessage()
            ], 500);
        }
    }

  public function withdraw()
    {
        $user = Auth::user();
        $methods = PaymentMethod::where('status', true)
                    ->where('is_active', true)
                    ->orderBy('order')
                    ->get();
        
        $transactions = Transaction::where('user_id', $user->id)
                        ->where('type', 'withdrawal')
                        ->latest()
                        ->limit(5)
                        ->get();
                    
        return view('user.transactions.withdraw', [
            'methods' => $methods,
            'user' => $user,
            'transactions' => $transactions,
            'wallet_info' => $user->wallet_info ?? []
        ]);
    }

    // Process withdrawal request
    public function withdrawStore(Request $request)
    {
        $user = Auth::user();
        
        $request->validate([
            'amount' => 'required|numeric|min:0.01',
            'method' => 'required|exists:payment_methods,name',
            'wallet_info' => 'required|array',
            'wallet_info.*' => 'required|string'
        ]);

        $method = PaymentMethod::where('name', $request->method)->first();

        // Check balance
        if ($user->balance < $request->amount) {
            return back()->with('error', 'আপনার ব্যালেন্স অপর্যাপ্ত!');
        }

        // Check min/max withdrawal limits
        if ($request->amount < $method->min_withdraw) {
            return back()->with('error', "সর্বনিম্ন উত্তোলন পরিমাণ {$method->min_withdraw} ৳");
        }

        if ($method->max_withdraw && $request->amount > $method->max_withdraw) {
            return back()->with('error', "সর্বোচ্চ উত্তোলন পরিমাণ {$method->max_withdraw} ৳");
        }

        // Check if wallet number is provided
        if (!isset($request->wallet_info[$request->method])) {
            return back()->with('error', 'অনুগ্রহ করে আপনার ওয়ালেট নম্বর প্রদান করুন');
        }

        // Save wallet info if not already saved
        $walletInfo = $user->wallet_info ?? [];
        if (!isset($walletInfo[$request->method])) {
            $walletInfo[$request->method] = $request->wallet_info[$request->method];
            $user->wallet_info = $walletInfo;
            $user->save();
        }

        // Deduct balance immediately
        $user->balance -= $request->amount;
        $user->save();

        // Create transaction record
        $transaction = Transaction::create([
            'user_id' => $user->id,
            'type' => 'withdrawal',
            'amount' => $request->amount,
            'method' => $request->method,
            'wallet_info' => $request->wallet_info[$request->method],
            'status' => 'pending'
        ]);

        // Here you would typically call payment gateway API
        // $this->processWithdrawal($transaction);

        return redirect()->route('transactions')
            ->with('success', 'উত্তোলনের অনুরোধ সফলভাবে জমা হয়েছে! প্রসেসিং সম্পন্ন হতে কিছু সময় লাগতে পারে।');
    }

    // Process actual withdrawal through payment gateway
    protected function processWithdrawal($transaction)
    {
        // Implement based on your payment gateway API
        // This is just a placeholder structure
        
        try {
            $response = $this->callPaymentGateway(
                $transaction->method,
                $transaction->wallet_info,
                $transaction->amount
            );
            
            if ($response->success) {
                $transaction->update([
                    'status' => 'approved',
                    'transaction_id' => $response->transaction_id
                ]);
            } else {
                $transaction->update([
                    'status' => 'failed',
                    'notes' => $response->message
                ]);
                
                // Refund user if withdrawal failed
                $user = $transaction->user;
                $user->balance += $transaction->amount;
                $user->save();
            }
            
        } catch (\Exception $e) {
            $transaction->update([
                'status' => 'failed',
                'notes' => $e->getMessage()
            ]);
            
            // Refund user on exception
            $user = $transaction->user;
            $user->balance += $transaction->amount;
            $user->save();
        }
    }

    // ট্রানজেকশন হিস্ট্রি
    public function index()
{
    $transactions = Transaction::with('paymentMethod')
                    ->where('user_id', Auth::id())
                    ->latest()
                    ->get();
                    
    return view('user.transactions.history', compact('transactions'));
}

}
