<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Setting;

use Illuminate\Support\Facades\Storage;
class SettingController extends Controller
{
   public function index()
    {
        // Define default settings if they don't exist
        $this->ensureSettingsExist();
        
        $settings = Setting::all()->groupBy('group');
        return view('admin.settings.index', compact('settings'));
    }

   public function update(Request $request)
{
    $validated = $request->validate([
        'site_name' => 'required|string|max:255',
        'site_logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'site_favicon' => 'nullable|image|mimes:ico,png|max:1024',
        'contact_email' => 'nullable|email',
        'contact_phone' => 'nullable|string',
    ]);

    foreach ($validated as $key => $value) {
        if ($request->hasFile($key)) {
            // Delete old file if exists
            $oldFile = Setting::where('key', $key)->value('value');
            if ($oldFile && file_exists(public_path($oldFile))) {
                unlink(public_path($oldFile));
            }

            // Store in public/images/settings directory
            $fileName = time().'_'.$request->file($key)->getClientOriginalName();
            $path = $request->file($key)->move(public_path('images/settings'), $fileName);
            $value = '/images/settings/'.$fileName;
        }

        Setting::updateOrCreate(
            ['key' => $key],
            ['value' => $value]
        );
    }

    return back()->with('success', 'Settings updated successfully');
}
    public function upload(Request $request)
    {
        $request->validate([
            'file' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        ]);

        $path = $request->file('file')->store('public/settings');
        $url = Storage::url($path);

        return response()->json([
            'location' => $url
        ]);
    }

    protected function ensureSettingsExist()
    {
        $defaultSettings = [
            'site_name' => ['value' => 'My Website', 'type' => 'text', 'group' => 'general'],
            'site_logo' => ['value' => '', 'type' => 'image', 'group' => 'general'],
            'site_favicon' => ['value' => '', 'type' => 'image', 'group' => 'general'],
            'contact_email' => ['value' => 'contact@example.com', 'type' => 'email', 'group' => 'contact'],
            'contact_phone' => ['value' => '+1234567890', 'type' => 'text', 'group' => 'contact'],
            'meta_description' => ['value' => 'Default meta description', 'type' => 'textarea', 'group' => 'seo'],
            'meta_keywords' => ['value' => 'keyword1, keyword2', 'type' => 'text', 'group' => 'seo'],
        ];

        foreach ($defaultSettings as $key => $data) {
            Setting::firstOrCreate(
                ['key' => $key],
                $data
            );
        }
    }
}
