<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\About;
class AboutController extends Controller
{
     public function edit()
    {
        $about = About::first();
        return view('admin.about.edit', compact('about'));
    }

    public function update(Request $request)
{
    $request->validate([
        'description' => 'required|string',
    ]);

    // Get the first record or create new if doesn't exist
    $about = About::firstOrNew();
    $about->description = $request->description;
    $about->save();

    return redirect()->route('admin.about.edit')
           ->with('success', 'About updated successfully!');
}

    public function show()
    {
        $about = About::first();
        return view('about', compact('about'));
    }
}
